/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.table.JXTableRowHeader;
import org.netbeans.modules.db.dataview.table.MultiColPatternFilter;
import org.netbeans.modules.db.dataview.table.SuperPatternFilter;
import org.openide.awt.MouseUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class DataViewUI
extends JPanel {
    private static final String IMG_PREFIX = "org/netbeans/modules/db/dataview/images/";
    private final JButton[] editButtons = new JButton[5];
    private final DataViewTableUI dataPanel;
    private final JScrollPane dataPanelScrollPane;
    private final DataViewPageContext pageContext;
    private final DataViewActionHandler actionHandler;
    private JButton commit;
    private JButton refreshButton;
    private JButton truncateButton;
    private JButton deleteRow;
    private JButton insert;
    private JTextField refreshField;
    private JTextField matchBoxField;
    private JLabel fetchedRowsLabel;
    private JLabel limitRow;
    private JButton cancel;
    private final PropertyChangeListener pageContextListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataViewUI.this.updateFetchedLabel();
        }
    };
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent evt) {
            AbstractButton button;
            Object src = evt.getSource();
            if (src instanceof AbstractButton && (button = (AbstractButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent evt) {
            Object src = evt.getSource();
            if (src instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)evt.getSource();
                button.setContentAreaFilled(false);
                button.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent evt) {
        }
    };
    private final ActionListener columnVisibilityToggler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            int index = Integer.parseInt(e.getActionCommand());
            Set<Integer> currentVisibleColumns = DataViewUI.this.dataPanel.getVisibleColumns();
            if (source.isSelected()) {
                currentVisibleColumns.add(index);
            } else {
                currentVisibleColumns.remove(index);
            }
            DataViewUI.this.dataPanel.setVisibleColumns(currentVisibleColumns);
        }
    };
    private final ActionListener fitColumnWidthToggler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((JCheckBox)e.getSource()).isSelected()) {
                DataViewUI.this.dataPanel.setAutoResizeMode(4);
            } else {
                DataViewUI.this.dataPanel.setAutoResizeMode(0);
            }
        }
    };
    private final ActionListener popupActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton button = (JButton)e.getSource();
            JCheckBox firstEntry = null;
            JPopupMenu popupMenu = new JPopupMenu();
            JPanel menuPanel = new JPanel();
            menuPanel.setFocusCycleRoot(true);
            popupMenu.add(menuPanel);
            menuPanel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 512;
            constraints.weightx = 1.0;
            constraints.gridx = 0;
            Set<Integer> visibleColumns = DataViewUI.this.dataPanel.getVisibleColumns();
            DataViewTableUIModel dvtm = DataViewUI.this.dataPanel.getModel();
            for (int i = 0; i < dvtm.getColumnCount(); ++i) {
                JCheckBox columnEntry = new JCheckBox(dvtm.getColumnName(i));
                columnEntry.setActionCommand(Integer.toString(i));
                columnEntry.setSelected(visibleColumns.contains(i));
                columnEntry.addActionListener(DataViewUI.this.columnVisibilityToggler);
                ++constraints.gridy;
                menuPanel.add((Component)columnEntry, constraints);
                if (firstEntry != null) continue;
                firstEntry = columnEntry;
            }
            ++constraints.gridy;
            menuPanel.add((Component)new JSeparator(), constraints);
            JCheckBox checkboxItem = new JCheckBox("Fit column width");
            checkboxItem.setSelected(DataViewUI.this.dataPanel.getAutoResizeMode() != 0);
            checkboxItem.addActionListener(DataViewUI.this.fitColumnWidthToggler);
            ++constraints.gridy;
            menuPanel.add((Component)checkboxItem, constraints);
            popupMenu.show(button, 0, button.getHeight());
            if (firstEntry == null) {
                checkboxItem.requestFocus();
            } else {
                firstEntry.requestFocus();
            }
        }
    };
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);

    DataViewUI(DataView dataView, DataViewPageContext pageContext, boolean nbOutputComponent) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.pageContext = pageContext;
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.putClientProperty("PersistenceType", "Never");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        JPanel panel = this.initializeMainPanel(nbOutputComponent);
        this.add((Component)panel, "North");
        this.actionHandler = new DataViewActionHandler(this, dataView, pageContext);
        this.dataPanel = new DataViewTableUI(this, this.actionHandler, dataView, pageContext);
        this.dataPanelScrollPane = new JScrollPane(this.dataPanel);
        this.dataPanelScrollPane.setVerticalScrollBarPolicy(22);
        this.dataPanelScrollPane.setHorizontalScrollBarPolicy(30);
        JXTableRowHeader rowHeader = new JXTableRowHeader(this.dataPanel);
        this.dataPanelScrollPane.setRowHeaderView(rowHeader);
        this.dataPanelScrollPane.setCorner("UPPER_LEFT_CORNER", rowHeader.getTableHeader());
        final Icon icon = ImageUtilities.loadIcon((String)"org/netbeans/modules/db/dataview/images/preferences-desktop.png", (boolean)false);
        JButton cornerButton = new JButton(this){
            final /* synthetic */ DataViewUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                int iconSize = Math.min(this.getWidth(), this.getHeight());
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                icon.paintIcon(null, g2d, (this.getWidth() - iconSize) / 2, (this.getHeight() - iconSize) / 2);
            }
        };
        cornerButton.addActionListener(this.popupActionListener);
        this.dataPanelScrollPane.setCorner("UPPER_RIGHT_CORNER", cornerButton);
        this.add((Component)this.dataPanelScrollPane, "Center");
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
        this.dataPanel.setModel(pageContext.getModel());
        pageContext.addPropertyChangeListener(this.pageContextListener);
        this.updateFetchedLabel();
    }

    void handleColumnUpdated() {
        boolean editMode = this.dataPanel.getModel().hasUpdates();
        this.commit.setEnabled(editMode);
        this.cancel.setEnabled(editMode);
        this.insert.setEnabled(!editMode);
        this.deleteRow.setEnabled(!editMode);
        this.truncateButton.setEnabled(!editMode);
    }

    JButton[] getEditButtons() {
        return this.editButtons;
    }

    final void updateFetchedLabel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.fetchedRowsLabel.setText(Integer.toString(this.pageContext.getModel().getRowCount()));
    }

    boolean isCommitEnabled() {
        return this.commit.isEnabled();
    }

    DataViewTableUI getDataViewTableUI() {
        return this.dataPanel;
    }

    DataViewTableUIModel getDataViewTableUIModel() {
        return this.dataPanel.getModel();
    }

    void setCommitEnabled(boolean flag) {
        this.commit.setEnabled(flag);
    }

    void setCancelEnabled(boolean flag) {
        this.cancel.setEnabled(flag);
    }

    void disableButtons() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.truncateButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.refreshField.setEnabled(false);
        this.matchBoxField.setEditable(false);
        this.deleteRow.setEnabled(false);
        this.commit.setEnabled(false);
        this.cancel.setEnabled(false);
        this.insert.setEnabled(false);
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
    }

    int getPageSize() {
        int pageSize = this.pageContext.getPageSize();
        try {
            int count = Integer.parseInt(this.refreshField.getText().trim());
            return count < 0 ? pageSize : count;
        }
        catch (NumberFormatException ex) {
            return pageSize;
        }
    }

    boolean isDirty() {
        return this.dataPanel.getModel().hasUpdates();
    }

    void resetToolbar(boolean wasError) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.refreshButton.setEnabled(true);
        this.refreshField.setEnabled(true);
        this.matchBoxField.setEditable(true);
        this.deleteRow.setEnabled(false);
        if (!wasError) {
            if (!this.dataPanel.getModel().isEditable()) {
                this.commit.setEnabled(false);
                this.cancel.setEnabled(false);
                this.deleteRow.setEnabled(false);
                this.insert.setEnabled(false);
                this.truncateButton.setEnabled(false);
            } else {
                if (this.pageContext.hasRows()) {
                    this.truncateButton.setEnabled(true);
                } else {
                    this.deleteRow.setEnabled(false);
                    this.truncateButton.setEnabled(false);
                    this.pageContext.first();
                }
                this.insert.setEnabled(true);
                if (this.getDataViewTableUIModel().getUpdateKeys().isEmpty()) {
                    this.commit.setEnabled(false);
                    this.cancel.setEnabled(false);
                } else {
                    this.commit.setEnabled(true);
                    this.cancel.setEnabled(true);
                }
            }
        } else {
            this.disableButtons();
        }
        this.refreshField.setText("" + this.pageContext.getPageSize());
        if (this.dataPanel != null) {
            this.dataPanel.revalidate();
            this.dataPanel.repaint();
        }
        this.updateFetchedLabel();
    }

    private ActionListener createOutputListener() {
        ActionListener outputListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src.equals(DataViewUI.this.refreshButton)) {
                    DataViewUI.this.actionHandler.refreshActionPerformed();
                } else if (src.equals(DataViewUI.this.refreshField)) {
                    DataViewUI.this.actionHandler.updateActionPerformed();
                } else if (src.equals(DataViewUI.this.commit)) {
                    DataViewUI.this.actionHandler.commitActionPerformed(false);
                } else if (src.equals(DataViewUI.this.cancel)) {
                    DataViewUI.this.actionHandler.cancelEditPerformed(false);
                } else if (src.equals(DataViewUI.this.deleteRow)) {
                    DataViewUI.this.actionHandler.deleteRecordActionPerformed();
                } else if (src.equals(DataViewUI.this.insert)) {
                    DataViewUI.this.actionHandler.insertActionPerformed();
                } else if (src.equals(DataViewUI.this.truncateButton)) {
                    DataViewUI.this.actionHandler.truncateActionPerformed();
                }
            }
        };
        return outputListener;
    }

    private void processButton(AbstractButton button) {
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setMargin(BUTTON_INSETS);
        if (button instanceof AbstractButton) {
            button.addMouseListener(sharedMouseListener);
        }
        button.setFocusable(false);
    }

    private void initToolbarWest(JToolBar toolbar, ActionListener outputListener, boolean nbOutputComponent) {
        if (!nbOutputComponent) {
            JButton[] btns;
            for (JButton btn : btns = this.getEditButtons()) {
                if (btn == null) continue;
                toolbar.add(btn);
            }
        }
        toolbar.addSeparator(new Dimension(10, 10));
        this.refreshButton = new JButton(ImageUtilities.loadIcon((String)"org/netbeans/modules/db/dataview/images/refresh.png"));
        this.refreshButton.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_refresh"));
        this.refreshButton.addActionListener(outputListener);
        this.processButton(this.refreshButton);
        toolbar.add(this.refreshButton);
        this.limitRow = new JLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_max_rows"));
        this.limitRow.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        toolbar.add(this.limitRow);
        this.refreshField = new JTextField(5);
        this.refreshField.setMinimumSize(this.refreshField.getPreferredSize());
        this.refreshField.setMaximumSize(this.refreshField.getPreferredSize());
        this.refreshField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DataViewUI.this.refreshField.selectAll();
            }
        });
        this.refreshField.addActionListener(outputListener);
        toolbar.add(this.refreshField);
        toolbar.addSeparator(new Dimension(10, 10));
        JLabel fetchedRowsNameLabel = new JLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_fetched_rows"));
        fetchedRowsNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataViewUI.class, (String)"LBL_fetched_rows"));
        fetchedRowsNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        toolbar.add(fetchedRowsNameLabel);
        this.fetchedRowsLabel = new JLabel();
        toolbar.add(this.fetchedRowsLabel);
        toolbar.addSeparator(new Dimension(10, 10));
    }

    private void initToolbarEast(JToolBar toolbar) {
        JLabel matchBoxRow = new JLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_matchbox"));
        matchBoxRow.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        toolbar.add(matchBoxRow);
        this.matchBoxField = new JTextField(10);
        this.matchBoxField.setText("");
        this.matchBoxField.setMinimumSize(new Dimension(35, this.matchBoxField.getHeight()));
        this.matchBoxField.setSize(35, this.matchBoxField.getHeight());
        this.matchBoxField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                DataViewUI.this.processKeyEvents();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DataViewUI.this.processKeyEvents();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DataViewUI.this.processKeyEvents();
            }
        });
        toolbar.add(this.matchBoxField);
    }

    private void processKeyEvents() {
        DataViewTableUI table = this.getDataViewTableUI();
        int[] rows = new int[table.getColumnCount()];
        for (int i = 0; i < table.getColumnCount(); ++i) {
            rows[i] = i;
        }
        MultiColPatternFilter filterP = new MultiColPatternFilter(rows);
        filterP.setFilterStr(this.matchBoxField.getText(), SuperPatternFilter.MODE.LITERAL_FIND);
        ((DefaultRowSorter)table.getRowSorter()).setRowFilter(filterP);
    }

    private void initVerticalToolbar(ActionListener outputListener) {
        this.insert = new JButton(ImageUtilities.loadIcon((String)"org/netbeans/modules/db/dataview/images/row_add.png"));
        this.insert.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_insert") + " (Alt+I)");
        this.insert.setMnemonic('I');
        this.insert.addActionListener(outputListener);
        this.insert.setEnabled(false);
        this.processButton(this.insert);
        this.editButtons[0] = this.insert;
        this.deleteRow = new JButton(ImageUtilities.loadIcon((String)"org/netbeans/modules/db/dataview/images/row_delete.png"));
        this.deleteRow.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_deleterow"));
        this.deleteRow.addActionListener(outputListener);
        this.deleteRow.setEnabled(false);
        this.processButton(this.deleteRow);
        this.editButtons[1] = this.deleteRow;
        this.commit = new JButton(ImageUtilities.loadIcon((String)"org/netbeans/modules/db/dataview/images/row_commit.png"));
        this.commit.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_commit_all"));
        this.commit.addActionListener(outputListener);
        this.commit.setEnabled(false);
        this.processButton(this.commit);
        this.editButtons[2] = this.commit;
        this.cancel = new JButton(ImageUtilities.loadIcon((String)"org/netbeans/modules/db/dataview/images/cancel_edits.png"));
        this.cancel.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_cancel_edits_all"));
        this.cancel.addActionListener(outputListener);
        this.cancel.setEnabled(false);
        this.processButton(this.cancel);
        this.editButtons[3] = this.cancel;
        this.truncateButton = new JButton(ImageUtilities.loadIcon((String)"org/netbeans/modules/db/dataview/images/table_truncate.png"));
        this.truncateButton.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_truncate_table") + " (Alt+T)");
        this.truncateButton.setMnemonic('T');
        this.truncateButton.addActionListener(outputListener);
        this.truncateButton.setEnabled(false);
        this.processButton(this.truncateButton);
        this.editButtons[4] = this.truncateButton;
    }

    private JPanel initializeMainPanel(boolean nbOutputComponent) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setLayout(new BoxLayout(panel, 2));
        ActionListener outputListener = this.createOutputListener();
        this.initVerticalToolbar(outputListener);
        JToolBar toolbarWest = new JToolBar();
        toolbarWest.setFloatable(false);
        toolbarWest.setRollover(true);
        this.initToolbarWest(toolbarWest, outputListener, nbOutputComponent);
        JToolBar toolbarEast = new JToolBar();
        toolbarEast.setFloatable(false);
        toolbarEast.setRollover(true);
        this.initToolbarEast(toolbarEast);
        toolbarEast.setMinimumSize(toolbarWest.getPreferredSize());
        toolbarEast.setSize(toolbarWest.getPreferredSize());
        toolbarEast.setMaximumSize(toolbarWest.getPreferredSize());
        panel.add(toolbarWest);
        panel.add(Box.createHorizontalGlue());
        panel.add(toolbarEast);
        return panel;
    }

    public void enableDeleteBtn(boolean value) {
        this.deleteRow.setEnabled(value);
    }
}

