/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.openide.util.NbBundle;

public class TimeType {
    public static final String DEFAULT_FOMAT_PATTERN = "HH:mm:ss";
    private static final DateFormat[] TIME_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("HH:mm:ss"), DateFormat.getTimeInstance(), DateFormat.getTimeInstance(3), new SimpleDateFormat("HH:mm")};
    public static final TimeZone TIME_ZONE = TimeZone.getDefault();
    private static final long INCREMENT_DAY = 86400000L;

    public TimeType() {
        for (int i = 0; i < TIME_PARSING_FORMATS.length; ++i) {
            TIME_PARSING_FORMATS[i].setLenient(false);
        }
    }

    public static long normalizeTime(long rawTimeMillis) {
        int dstOffset = TIME_ZONE.inDaylightTime(new Date(rawTimeMillis)) ? TIME_ZONE.getDSTSavings() : 0;
        return rawTimeMillis < 86400000L ? rawTimeMillis : rawTimeMillis % 86400000L + (long)dstOffset;
    }

    private static Time getNormalizedTime(long time) {
        Time ret = null;
        ret = new Time(TimeType.normalizeTime(time));
        return ret;
    }

    public static Time convert(Object value) throws DBException {
        if (null == value) {
            return null;
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof String) {
            Date dVal = TimeType.doParse((String)value);
            if (dVal == null) {
                throw new DBException(NbBundle.getMessage(TimeType.class, (String)"LBL_invalid_time"));
            }
            return TimeType.getNormalizedTime(dVal.getTime());
        }
        throw new DBException(NbBundle.getMessage(TimeType.class, (String)"LBL_invalid_time"));
    }

    private static synchronized Date doParse(String sVal) {
        Date dVal = null;
        for (DateFormat format : TIME_PARSING_FORMATS) {
            try {
                dVal = format.parse(sVal);
                break;
            }
            catch (ParseException ex) {
                Logger.getLogger(TimeType.class.getName()).log(Level.FINEST, ex.getLocalizedMessage(), ex);
            }
        }
        return dVal;
    }
}

