/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JPAVerificationTaskProvider
extends FileTaskScanner {
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";

    public JPAVerificationTaskProvider() {
        super(NbBundle.getMessage(JPAVerificationTaskProvider.class, (String)"LBL_TaskList_DisplayName"), NbBundle.getMessage(JPAVerificationTaskProvider.class, (String)"LBL_TaskList_Desc"), null);
    }

    public List<? extends org.netbeans.spi.tasklist.Task> scan(FileObject file) {
        JavaSource javaSrc = null;
        try {
            javaSrc = JavaSource.forFileObject((FileObject)file);
        }
        catch (IllegalArgumentException ie) {
            JPAProblemFinder.LOG.log(Level.WARNING, ie.getMessage(), ie);
            return null;
        }
        JPAProblemFinder.ProblemFinderCompControl compControl = new JPAProblemFinder.ProblemFinderCompControl(file);
        if (javaSrc != null) {
            try {
                javaSrc.runUserActionTask((Task)compControl, true);
            }
            catch (IOException e) {
                JPAProblemFinder.LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
        ArrayList<org.netbeans.spi.tasklist.Task> tasks = new ArrayList<org.netbeans.spi.tasklist.Task>();
        for (ErrorDescription errorDescription : compControl.getProblemsFound()) {
            try {
                org.netbeans.spi.tasklist.Task task = org.netbeans.spi.tasklist.Task.create((FileObject)file, (String)JPAVerificationTaskProvider.severityToTaskListString(errorDescription.getSeverity()), (String)errorDescription.getDescription(), (int)errorDescription.getRange().getBegin().getLine());
                tasks.add(task);
            }
            catch (IOException e) {
                JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return tasks;
    }

    public void attach(FileTaskScanner.Callback callback) {
    }

    private static String severityToTaskListString(Severity severity) {
        if (severity == Severity.ERROR) {
            return TASKLIST_ERROR;
        }
        return TASKLIST_WARNING;
    }
}

