/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.insane.model;

import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import org.netbeans.insane.model.BinaryHeapModel;
import org.netbeans.insane.model.HeapModel;
import org.netbeans.insane.model.InsaneConverter;
import org.netbeans.insane.model.Item;
import org.netbeans.insane.model.XmlHeapModel;

public final class Support {
    private Support() {
    }

    public static HeapModel parseSimpleXMLDump(File file) throws Exception {
        return XmlHeapModel.parse(file);
    }

    public static HeapModel openSimpleBinaryDump(File file) throws Exception {
        return BinaryHeapModel.open(file);
    }

    public static void convertSimpleDump(File from, File to) throws Exception {
        InsaneConverter.convert(from, to);
    }

    public static void findRoots(HeapModel model, Item itm, boolean weak) {
        LinkedList<PathElement> queue = new LinkedList<PathElement>();
        queue.add(new PathElement(itm, null));
        HashSet<Item> visited = new HashSet<Item>(queue);
        while (!queue.isEmpty()) {
            PathElement act = (PathElement)queue.remove(0);
            Enumeration<Object> en = act.getItem().incomming();
            while (en.hasMoreElements()) {
                Object o = en.nextElement();
                if (o instanceof String) {
                    System.out.println(o + "->\n" + act);
                    return;
                }
                Item ref = (Item)o;
                if (!weak && ("java.lang.ref.WeakReference".equals(ref.getType()) || "javax.swing.AbstractActionPropertyChangeListener$OwnedWeakReference".equals(ref.getType()) || "org.openide.util.WeakListener$ListenerReference".equals(ref.getType()) || "org.openide.util.WeakListenerImpl$ListenerReference".equals(ref.getType()) || "org.openide.util.WeakSet$Entry".equals(ref.getType()) || "java.lang.ref.SoftReference".equals(ref.getType()) || "org.netbeans.modules.javacore.classpath.MergedClassPathImplementation$ClassPathMap$WeakPair".equals(ref.getType()) || "java.util.WeakHashMap$Entry".equals(ref.getType()) || "org.netbeans.modules.project.ant.FileChangeSupport$Holder".equals(ref.getType()) | "org.netbeans.api.nodes2looks.LookNode$FirerImpl".equals(ref.getType()) || "org.openide.loaders.DataObjectPool$ItemReference".equals(ref.getType()) || "org.netbeans.mdr.NBMDRepositoryImpl$FacilityCache$HandlerReference".equals(ref.getType()) || "org.netbeans.mdr.storagemodel.MdrStorage$InstanceMap$InstanceReference".equals(ref.getType()) || "org.openide.util.IconManager$ActiveRef".equals(ref.getType())) || !visited.add(ref)) continue;
                queue.add(new PathElement(ref, act));
            }
        }
    }

    private static class PathElement {
        private Item item;
        private PathElement next;

        public PathElement(Item item, PathElement next) {
            this.item = item;
            this.next = next;
        }

        public Item getItem() {
            return this.item;
        }

        public String toString() {
            if (this.next == null) {
                return this.item.toString();
            }
            return this.item.toString() + "->\n" + this.next.toString();
        }
    }
}

