/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.execute.navigator.TasksNavigatorHint;
import org.netbeans.modules.gradle.nodes.GradleProjectNode;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.PathFinder;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class LogicalViewProviderImpl
implements LogicalViewProvider {
    private final Project proj;

    public LogicalViewProviderImpl(Project proj) {
        this.proj = proj;
    }

    public Node createLogicalView() {
        NbGradleProjectImpl project = (NbGradleProjectImpl)this.proj.getLookup().lookup(NbGradleProjectImpl.class);
        return new GradleProjectNode(LogicalViewProviderImpl.createLookup(project), project);
    }

    private static Lookup createLookup(NbGradleProjectImpl project) {
        if (!project.getProjectDirectory().isValid()) {
            return Lookups.fixed((Object[])new Object[]{project});
        }
        DataFolder rootFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, rootFolder, project.getProjectDirectory(), new TasksNavigatorHint()});
    }

    public Node findPath(Node node, Object target) {
        NbGradleProjectImpl prj = (NbGradleProjectImpl)node.getLookup().lookup(NbGradleProjectImpl.class);
        if (prj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            Node[] nodes;
            FileObject fo = (FileObject)target;
            if (LogicalViewProviderImpl.isOtherProjectSource(fo, prj)) {
                return null;
            }
            for (Node n : nodes = node.getChildren().getNodes(true)) {
                Node result;
                PathFinder pf = (PathFinder)n.getLookup().lookup(PathFinder.class);
                if (pf == null || (result = pf.findPath(n, target)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private static boolean isOtherProjectSource(@NonNull FileObject fo, @NonNull Project me) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return false;
        }
        if (me.equals((Object)owner)) {
            return false;
        }
        return false;
    }
}

