/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.openide.util.HelpCtx;

public abstract class ProfilingPointReport
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY = "ProfilingPointReport.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProfilingPointReport.HelpCtx");
    private static final ProfilingSettings REF_CPU_INSTR = ProfilingSettingsPresets.createCPUPreset((int)8);
    private static final Set<ProfilingPointReport> openReports = new HashSet<ProfilingPointReport>();
    private static boolean profilingRunning;
    private static ProfilingSettings currentSettings;

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public final int getPersistenceType() {
        return 2;
    }

    protected final String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected abstract void refresh();

    public static String getNoDataHint(ProfilingPoint profilingPoint) {
        if (!profilingRunning || profilingPoint.supportsProfilingSettings(currentSettings)) {
            return "&nbsp;&nbsp;&lt;" + Bundle.ProfilingPointReport_NoHitsString() + "&gt;";
        }
        if (ProfilingSettings.isMonitorSettings((ProfilingSettings)currentSettings)) {
            return "&nbsp;&nbsp;" + Bundle.ProfilingPointReport_NoMonitorString();
        }
        if (ProfilingSettings.isCPUSettings((ProfilingSettings)currentSettings)) {
            if (!profilingPoint.supportsProfilingSettings(REF_CPU_INSTR)) {
                return "&nbsp;&nbsp;" + Bundle.ProfilingPointReport_NoCpuString();
            }
            return "&nbsp;&nbsp;" + Bundle.ProfilingPointReport_NoSampledCpuString();
        }
        if (ProfilingSettings.isMemorySettings((ProfilingSettings)currentSettings)) {
            return "&nbsp;&nbsp;" + Bundle.ProfilingPointReport_NoMemoryString();
        }
        return "&nbsp;&nbsp;" + Bundle.ProfilingPointReport_NoCurrentString();
    }

    protected void componentOpened() {
        super.componentOpened();
        openReports.add(this);
    }

    protected void componentClosed() {
        openReports.remove((Object)this);
        super.componentClosed();
    }

    public static void refreshOpenReports() {
        Profiler profiler = Profiler.getDefault();
        profilingRunning = profiler.profilingInProgress();
        currentSettings = profiler.getLastProfilingSettings();
        if (profiler.getProfilingState() != 4 && profiler.getProfilingState() != 1) {
            return;
        }
        for (ProfilingPointReport report : openReports) {
            report.refresh();
        }
    }
}

