/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.awt.Dialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.DerbyDatabasesImpl;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.ui.CreateSampleDatabasePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class CreateSampleDBAction
extends CallableSystemAction {
    private static final Logger LOG = Logger.getLogger(CreateSampleDBAction.class.getName());

    public CreateSampleDBAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        if (!Util.checkInstallLocation()) {
            return;
        }
        if (!Util.ensureSystemHome()) {
            return;
        }
        String derbySystemHome = DerbyOptions.getDefault().getSystemHome();
        CreateSampleDatabasePanel panel = new CreateSampleDatabasePanel(derbySystemHome);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(CreateSampleDBAction.class, (String)"LBL_CreateSampleDatabaseTitle"), true, null);
        desc.createNotificationLineSupport();
        panel.setDialogDescriptor(desc);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        panel.setIntroduction();
        String acsd = NbBundle.getMessage(CreateSampleDBAction.class, (String)"ACSD_CreateDatabaseAction");
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        dialog.setVisible(true);
        dialog.dispose();
        if (!DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
            return;
        }
        String databaseName = panel.getDatabaseName();
        try {
            DerbyDatabasesImpl.getDefault().createSampleDatabase(databaseName, true);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, null, e);
            LOG.log(Level.INFO, "", e);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)("Failed to ceate sample database:\n" + e.getLocalizedMessage()), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    public boolean isEnabled() {
        return Util.hasInstallLocation();
    }

    public String getName() {
        return NbBundle.getBundle(CreateSampleDBAction.class).getString("LBL_CreateSampleDBAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CreateSampleDBAction.class);
    }
}

