/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.jade.editor.lexer.JadeTokenId;

public class JadeStructureScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(ParserResult info) {
        return Collections.emptyList();
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        TokenHierarchy th = info.getSnapshot().getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JadeTokenId.jadeLanguage());
        List list = th.tokenSequenceList(ts.languagePath(), 0, info.getSnapshot().getText().length());
        ts.moveStart();
        int indent = 0;
        int commentDelStart = 0;
        int commentDelLength = 0;
        ArrayList<FoldingItem> stack = new ArrayList<FoldingItem>();
        boolean afterEOL = true;
        while (ts.moveNext()) {
            Token token = ts.token();
            JadeTokenId id = (JadeTokenId)token.id();
            if (afterEOL) {
                if (id == JadeTokenId.WHITESPACE) {
                    indent = token.length();
                } else if (id == JadeTokenId.TAG || id == JadeTokenId.KEYWORD_BLOCK || id == JadeTokenId.KEYWORD_MIXIN) {
                    afterEOL = false;
                    stack.add(new FoldingItem(FoldType.TAG, indent, ts.offset(), ts.offset() + token.length()));
                } else if (id != JadeTokenId.COMMENT_DELIMITER && id != JadeTokenId.UNBUFFERED_COMMENT_DELIMITER) {
                    afterEOL = false;
                } else {
                    commentDelStart = ts.offset();
                    commentDelLength = token.length();
                }
                if (id == JadeTokenId.COMMENT || id == JadeTokenId.UNBUFFERED_COMMENT) {
                    String comment = token.text().toString();
                    while (!comment.isEmpty() && comment.charAt(comment.length() - 1) == '\n') {
                        comment = comment.substring(0, comment.length() - 1);
                    }
                    if (comment.indexOf(10) >= 0) {
                        stack.add(new FoldingItem(FoldType.COMMENT, indent, commentDelStart, commentDelStart + commentDelLength));
                    }
                    afterEOL = true;
                }
            }
            if (id != JadeTokenId.EOL) continue;
            afterEOL = true;
            indent = 0;
        }
        if (!stack.isEmpty()) {
            for (int i = 0; i < stack.size(); ++i) {
                FoldingItem item1 = (FoldingItem)stack.get(i);
                boolean foldCreated = false;
                for (int j = i + 1; j < stack.size(); ++j) {
                    FoldingItem item2 = (FoldingItem)stack.get(j);
                    if (item1.indent < item2.indent) continue;
                    foldCreated = true;
                    this.appendFold(info, folds, item1.type.code(), item1.tagEnd, item2.tagStart - item2.indent - 1);
                    break;
                }
                if (foldCreated) continue;
                this.appendFold(info, folds, FoldType.TAG.code(), item1.tagEnd, ts.offset() + ts.token().length());
            }
        }
        return folds;
    }

    private void appendFold(ParserResult info, Map<String, List<OffsetRange>> folds, String kind, int startOffset, int endOffset) {
        if (startOffset >= 0 && endOffset >= startOffset && info.getSnapshot().getText().subSequence(startOffset, endOffset).toString().indexOf(10) > -1) {
            this.getRanges(folds, kind).add(new OffsetRange(startOffset, endOffset));
        }
    }

    private List<OffsetRange> getRanges(Map<String, List<OffsetRange>> folds, String kind) {
        List<OffsetRange> ranges = folds.get(kind);
        if (ranges == null) {
            ranges = new ArrayList<OffsetRange>();
            folds.put(kind, ranges);
        }
        return ranges;
    }

    public StructureScanner.Configuration getConfiguration() {
        return null;
    }

    private static class FoldingItem {
        final int indent;
        final int tagStart;
        final int tagEnd;
        final FoldType type;

        public FoldingItem(FoldType type, int indent, int tagStart, int tagEnd) {
            this.indent = indent;
            this.tagStart = tagStart;
            this.tagEnd = tagEnd;
            this.type = type;
        }
    }
}

