/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.process;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.prep.process.Bundle;
import org.netbeans.modules.css.prep.util.BaseCssPreprocessor;
import org.netbeans.modules.css.prep.util.CssPreprocessorUtils;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

abstract class BaseProcessor {
    private static final Logger LOGGER = Logger.getLogger(BaseProcessor.class.getName());
    protected final BaseCssPreprocessor cssPreprocessor;
    private final Set<FileObject> processedFiles = new HashSet<FileObject>();

    BaseProcessor(BaseCssPreprocessor cssPreprocessor) {
        assert (cssPreprocessor != null);
        this.cssPreprocessor = cssPreprocessor;
    }

    protected abstract boolean isEnabledInternal(@NonNull Project var1);

    protected abstract boolean isSupportedFile(FileObject var1);

    protected abstract boolean isPartial(FileObject var1);

    protected abstract List<Pair<String, String>> getMappings(Project var1);

    protected abstract String getCompilerOptions(Project var1);

    protected abstract void compileInternal(Project var1, File var2, File var3, File var4, List<String> var5);

    public void process(Project project, FileObject fileObject, String originalName, String originalExtension) {
        if (!this.isEnabled(project)) {
            return;
        }
        if (fileObject.isData()) {
            this.processFile(project, fileObject, originalName, originalExtension);
        } else {
            assert (fileObject.isFolder()) : "Folder expected: " + fileObject;
            this.processFolder(project, fileObject);
        }
    }

    private void processFolder(Project project, FileObject fileObject) {
        assert (fileObject.isFolder()) : "Folder expected: " + fileObject;
        for (FileObject child : fileObject.getChildren()) {
            if (child.isData()) {
                this.processFile(project, child, null, null);
                continue;
            }
            this.processFolder(project, child);
        }
    }

    private void processFile(Project project, FileObject fileObject, String originalName, String originalExtension) {
        assert (fileObject.isData()) : "File expected: " + fileObject;
        if (!this.isSupportedFile(fileObject)) {
            return;
        }
        if (!this.processedFiles.add(fileObject)) {
            return;
        }
        if (fileObject.isValid()) {
            this.fileChanged(project, fileObject);
            if (originalName != null) {
                this.fileRenamed(project, fileObject, originalName, originalExtension);
            }
        } else {
            this.fileDeleted(project, fileObject);
        }
    }

    private boolean isEnabled(Project project) {
        if (project == null) {
            return true;
        }
        return this.isEnabledInternal(project);
    }

    protected void fileChanged(Project project, FileObject fileObject) {
        if (!this.isPartial(fileObject)) {
            this.compile(project, fileObject);
        }
        this.compileReferences(project, fileObject);
    }

    protected void compile(Project project, FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            LOGGER.log(Level.WARNING, "Not compiling, file not found for fileobject {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
            return;
        }
        FileObject webRoot = this.getWebRoot(project, fileObject);
        File target = this.getTargetFile(project, webRoot, file);
        if (target == null) {
            return;
        }
        this.compileInternal(project, FileUtil.toFile((FileObject)webRoot), file, target, CssPreprocessorUtils.parseCompilerOptions(this.getCompilerOptions(project), webRoot));
    }

    protected void compileReferences(Project project, FileObject fileObject) {
        if (project == null) {
            LOGGER.log(Level.INFO, "Cannot compile 'import' file {0}, no project", fileObject);
            return;
        }
        try {
            DependenciesGraph dependenciesGraph = CssIndex.get((Project)project).getDependencies(fileObject);
            for (FileObject referring : dependenciesGraph.getAllReferingFiles()) {
                if (fileObject.equals(referring)) continue;
                this.processFile(project, referring, null, null);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private void fileRenamed(Project project, FileObject fileObject, String originalName, String originalExtension) {
        assert (originalName != null) : fileObject;
        assert (originalExtension != null) : fileObject;
        File originalFile = new File(FileUtil.toFile((FileObject)fileObject).getParentFile(), originalName + "." + originalExtension);
        File targetFile = this.getTargetFile(project, this.getWebRoot(project, fileObject), originalFile);
        this.deleteFile(targetFile);
        this.deleteMapFile(targetFile);
    }

    private void fileDeleted(Project project, FileObject fileObject) {
        File targetFile = this.getTargetFile(project, this.getWebRoot(project, fileObject), FileUtil.toFile((FileObject)fileObject));
        this.deleteFile(targetFile);
        this.deleteMapFile(targetFile);
    }

    private void deleteMapFile(File targetFile) {
        if (targetFile == null) {
            return;
        }
        this.deleteFile(this.getMapFile(targetFile));
    }

    protected File getMapFile(@NonNull File targetFile) {
        assert (targetFile != null);
        return new File(targetFile.getParent(), targetFile.getName() + ".map");
    }

    private void deleteFile(File file) {
        if (file == null || !file.isFile()) {
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        assert (fo != null);
        try {
            fo.delete();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot delete file", ex);
        }
    }

    @CheckForNull
    protected File getTargetFile(Project project, FileObject webRoot, File file) {
        if (webRoot == null) {
            LOGGER.log(Level.INFO, "Not compiling, file {0} not underneath web root of project {1}", new Object[]{file, FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())});
            return null;
        }
        List<Pair<String, String>> mappings = this.getMappings(project);
        if (mappings.isEmpty()) {
            LOGGER.log(Level.INFO, "Not compiling, no mappings for project {0}", FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
            this.cssPreprocessor.fireProcessingErrorOccured(project, Bundle.BaseProcessor_error_mappings_empty(this.cssPreprocessor.getDisplayName()));
            return null;
        }
        File target = CssPreprocessorUtils.resolveTarget(webRoot, mappings, file);
        if (target == null) {
            LOGGER.log(Level.INFO, "Not compiling, file {0} not matched within current mappings {1}", new Object[]{file, mappings});
            return null;
        }
        return target;
    }

    @CheckForNull
    private FileObject getWebRoot(Project project, FileObject fileObject) {
        FileObject webRoot = CssPreprocessorUtils.getWebRoot(project, fileObject);
        if (webRoot != null) {
            return webRoot;
        }
        return CssPreprocessorUtils.getWebRoot(project);
    }
}

