/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaMethod;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaParameter;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.MethodNodeActionsProvider;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.util.SaasTransferable;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.modules.websvc.saas.util.TypeUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class WsdlMethodNode
extends AbstractNode {
    private WsdlSaasMethod method;
    private Transferable transferable;

    public WsdlMethodNode(WsdlSaasMethod method) {
        this(method, new InstanceContent());
    }

    protected WsdlMethodNode(WsdlSaasMethod method, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.method = method;
        content.add((Object)method);
        this.transferable = ExTransferable.create((Transferable)new SaasTransferable((Object)method, SaasTransferable.WSDL_METHOD_FLAVORS));
    }

    public String getDisplayName() {
        return this.method.getName();
    }

    public String getShortDescription() {
        String signature;
        JavaMethod javaMethod = this.method.getJavaMethod();
        if (javaMethod != null) {
            signature = javaMethod.getReturnType().getFormalName() + " " + javaMethod.getName() + "(";
            Iterator parameterIterator = javaMethod.getParametersList().iterator();
            while (parameterIterator.hasNext()) {
                JavaParameter currentParam = (JavaParameter)parameterIterator.next();
                String parameterType = TypeUtil.getParameterType((JavaParameter)currentParam);
                signature = signature + parameterType + " " + currentParam.getName();
                if (!parameterIterator.hasNext()) continue;
                signature = signature + ", ";
            }
        } else {
            WSOperation wsOperation = this.method.getWsdlOperation();
            signature = wsOperation.getName() + "(";
            ListIterator iterator = wsOperation.getParameters().listIterator();
            while (iterator.hasNext()) {
                WSParameter parameter = (WSParameter)iterator.next();
                signature = signature + parameter.getName();
                if (!iterator.hasNext()) continue;
                signature = signature + ", ";
            }
        }
        signature = signature + ")";
        return signature;
    }

    public Action[] getActions(boolean context) {
        List<Action> actions = SaasNode.getActions(this.getLookup());
        for (MethodNodeActionsProvider ext : SaasUtil.getMethodNodeActionsProviders()) {
            actions.addAll(Arrays.asList(ext.getMethodActions(this.getLookup())));
        }
        return actions.toArray(new Action[0]);
    }

    public Action getPreferredAction() {
        Action[] actions = this.getActions(true);
        return actions.length > 0 ? actions[0] : null;
    }

    public Image getIcon(int type) {
        return this.getMethodIcon();
    }

    public Image getOpenedIcon(int type) {
        return this.getMethodIcon();
    }

    private Image getMethodIcon() {
        JavaMethod javaMethod = this.method.getJavaMethod();
        if (javaMethod != null && !"void".equals(javaMethod.getReturnType().getRealName())) {
            Image image1 = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/manager/resources/methodicon.png");
            Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/manager/resources/table_dp_badge.png");
            int x = image1.getWidth(null) - image2.getWidth(null);
            int y = image1.getHeight(null) - image2.getHeight(null);
            return ImageUtilities.mergeImages((Image)image1, (Image)image2, (int)x, (int)y);
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/ui/resources/methodicon.png");
    }

    protected Sheet createSheet() {
        JavaMethod javaMethod = this.method.getJavaMethod();
        Sheet sheet = super.createSheet();
        Sheet.Set ss = sheet.get("data");
        if (ss == null) {
            ss = new Sheet.Set();
            ss.setName("data");
            ss.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_INFO"));
            ss.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_INFO"));
            sheet.put(ss);
        }
        if (javaMethod == null) {
            return sheet;
        }
        try {
            Sheet.Set exceptionSet;
            Iterator paramIterator;
            PropertySupport.Reflection p = new PropertySupport.Reflection((Object)javaMethod, String.class, "getName", null);
            p.setName("name");
            p.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_NAME"));
            p.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_NAME"));
            ss.put((Node.Property)p);
            String signature = javaMethod.getReturnType().getRealName() + " " + javaMethod.getName() + "(";
            Iterator tempIterator = javaMethod.getParametersList().iterator();
            while (tempIterator.hasNext()) {
                JavaParameter currentparam = (JavaParameter)tempIterator.next();
                signature = signature + currentparam.getType().getRealName() + " " + currentparam.getName();
                if (!tempIterator.hasNext()) continue;
                signature = signature + ", ";
            }
            signature = signature + ")";
            Iterator excpIterator = javaMethod.getExceptions();
            if (excpIterator.hasNext()) {
                signature = signature + " throws";
                while (excpIterator.hasNext()) {
                    String currentExcp = (String)excpIterator.next();
                    signature = signature + " " + currentExcp;
                    if (!excpIterator.hasNext()) continue;
                    signature = signature + ",";
                }
            }
            p = new PropertySupport.Reflection((Object)signature, String.class, "toString", null);
            p.setName("signature");
            p.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_SIGNATURE"));
            p.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_SIGNATURE"));
            ss.put((Node.Property)p);
            p = new PropertySupport.Reflection((Object)javaMethod.getReturnType(), String.class, "getRealName", null);
            p.setName("returntype");
            p.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_RETURNTYPE"));
            p.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_RETURNTYPE"));
            ss.put((Node.Property)p);
            Sheet.Set paramSet = sheet.get("parameters");
            if (paramSet == null) {
                paramSet = new Sheet.Set();
                paramSet.setName("parameters");
                paramSet.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMDIVIDER"));
                paramSet.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMDIVIDER"));
                sheet.put(paramSet);
            }
            if ((paramIterator = javaMethod.getParametersList().iterator()).hasNext()) {
                p = new PropertySupport.Reflection((Object)NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMTYPE"), String.class, "toString", null);
                p.setName("paramdivider2");
                int ii = 0;
                while (paramIterator.hasNext()) {
                    JavaParameter currentParameter = (JavaParameter)paramIterator.next();
                    p = currentParameter.getType().isHolder() ? new PropertySupport.Reflection((Object)TypeUtil.getParameterType((JavaParameter)currentParameter), String.class, "toString", null) : new PropertySupport.Reflection((Object)currentParameter.getType(), String.class, "getRealName", null);
                    p.setName("paramname" + ii);
                    p.setDisplayName(currentParameter.getName());
                    p.setShortDescription(currentParameter.getName() + "-" + currentParameter.getType().getRealName());
                    paramSet.put((Node.Property)p);
                    ++ii;
                }
            }
            if ((exceptionSet = sheet.get("exceptions")) == null) {
                exceptionSet = new Sheet.Set();
                exceptionSet.setName("exceptions");
                exceptionSet.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_EXCEPTIONDIVIDER"));
                exceptionSet.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_EXCEPTIONDIVIDER"));
                sheet.put(exceptionSet);
            }
            Iterator exceptionIterator = javaMethod.getExceptions();
            int ii = 0;
            while (exceptionIterator.hasNext()) {
                String currentException = (String)exceptionIterator.next();
                p = new PropertySupport.Reflection((Object)currentException, String.class, "toString", null);
                p.setName("exception" + ii);
                p.setDisplayName(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMTYPE"));
                p.setShortDescription(NbBundle.getMessage(WsdlMethodNode.class, (String)"METHOD_PARAMTYPE"));
                exceptionSet.put((Node.Property)p);
                ++ii;
            }
        }
        catch (NoSuchMethodException nsme) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, nsme.getLocalizedMessage(), nsme);
        }
        return sheet;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public Transferable clipboardCopy() throws IOException {
        if (this.method.getSaas().getState() == Saas.State.READY) {
            return SaasTransferable.addFlavors((Transferable)this.transferable);
        }
        this.method.getSaas().toStateReady(false);
        return super.clipboardCopy();
    }
}

