/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.netbeans.modules.cnd.debugger.gdb2.GdbVersionPeculiarity;

public class GdbUtils {
    private GdbUtils() {
    }

    public static String gdbToUserEncoding(String string, String encoding) {
        char[] chars = string.toCharArray();
        boolean escape = false;
        ArrayList<Byte> _bytes = new ArrayList<Byte>();
        for (int i = 0; i < chars.length; ++i) {
            char next;
            char ch = chars[i];
            char c = next = i + 1 < chars.length ? chars[i + 1] : (char)'\u0000';
            if (escape) {
                escape = false;
            } else if (ch == '\\') {
                if (Character.isDigit(next)) {
                    char[] charVal = new char[]{chars[++i], chars[++i], chars[++i]};
                    ch = (char)Integer.parseInt(String.valueOf(charVal), 8);
                } else {
                    escape = true;
                }
            }
            _bytes.add((byte)ch);
        }
        byte[] bytes = new byte[_bytes.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (Byte)_bytes.get(i);
        }
        try {
            string = new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public static GdbVersionPeculiarity.Version parseVersionString(String msg) throws NumberFormatException {
        int last;
        int first;
        int dot = msg.indexOf(46);
        for (first = dot - 1; first > 0 && Character.isDigit(msg.charAt(first)); --first) {
        }
        first = Integer.parseInt(msg.substring(first + 1, dot));
        for (last = dot + 1; last < msg.length() && Character.isDigit(msg.charAt(last)); ++last) {
        }
        last = Integer.parseInt(msg.substring(dot + 1, last));
        return new GdbVersionPeculiarity.Version(first, last);
    }
}

