/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.util.ArrayList;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerationManager;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SoapClientEditorDrop
implements ActiveEditorDrop {
    private WsdlSaasMethod method;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;

    public SoapClientEditorDrop(WsdlSaasMethod method) {
        this.method = method;
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        if (SaasClientCodeGenerationManager.canAccept((SaasMethod)this.method, targetComponent.getDocument())) {
            return this.doHandleTransfer(targetComponent);
        }
        return false;
    }

    private boolean doHandleTransfer(final JTextComponent targetComponent) {
        final Document targetDoc = targetComponent.getDocument();
        FileObject targetSource = NbEditorUtilities.getFileObject((Document)targetComponent.getDocument());
        WSOperation op = this.method.getWsdlOperation();
        final String displayName = op.getName();
        this.targetFO = SoapClientEditorDrop.getTargetFile(targetComponent);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList errors = new ArrayList();
        final ProgressDialog dialog = new ProgressDialog(NbBundle.getMessage(SoapClientEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)displayName));
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){
            final /* synthetic */ SoapClientEditorDrop this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean response;
                    SaasClientCodeGenerator codegen = (SaasClientCodeGenerator)SaasClientCodeGenerationManager.lookup((SaasMethod)this.this$0.method, targetDoc);
                    codegen.init((SaasMethod)this.this$0.method, targetDoc);
                    codegen.setDropLocation(targetComponent);
                    SoapClientSaasBean bean = (SoapClientSaasBean)codegen.getBean();
                    ArrayList<ParameterInfo> allParams = new ArrayList<ParameterInfo>(bean.getHeaderParameters());
                    if (bean.getInputParameters() != null) {
                        allParams.addAll(bean.getInputParameters());
                    }
                    if (response = Util.showDialog(displayName, allParams, targetDoc)) {
                        Util.doGenerateCode(codegen, dialog, errors);
                    }
                }
                catch (Exception ioe) {
                    errors.add(ioe);
                }
                finally {
                    dialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        dialog.open();
        if (errors.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)errors.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(JTextComponent targetComponent) {
        if (targetComponent == null) {
            return null;
        }
        DataObject d = NbEditorUtilities.getDataObject((Document)targetComponent.getDocument());
        if (d == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
        if (ec == null || ec.getOpenedPanes() == null) {
            return null;
        }
        return d.getPrimaryFile();
    }
}

