/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.api;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class ProcessUtilities {
    private static final Logger LOGGER = Logger.getLogger(ProcessUtilities.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ProcessUtilities.class.getName(), 20);
    private static InputOutput io;

    private static void logOut(String s) {
        if (io != null) {
            io.getOut().append((CharSequence)s);
            io.getOut().flush();
        }
    }

    private static void logErr(String s) {
        if (io != null) {
            io.getErr().append((CharSequence)s);
            io.getErr().flush();
        }
    }

    public static String callProcess(final String executable, boolean wait, int timeout, String ... parameters) throws IOException {
        ProcessBuilder pb = ProcessBuilder.getLocal();
        pb.setExecutable(executable);
        pb.setArguments(Arrays.asList(parameters));
        final Process call = pb.call();
        ProcessUtilities.logOut(">" + executable);
        for (String parameter : parameters) {
            ProcessUtilities.logOut(" " + parameter);
        }
        ProcessUtilities.logOut("\n");
        if (timeout > 0) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        call.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        call.destroy();
                        LOGGER.severe("process " + executable + " killed.");
                    }
                }
            }, timeout);
        }
        StringBuilder error = new StringBuilder();
        RequestProcessor.Task errTask = RP.post((Runnable)new Redirector(call.getErrorStream(), error));
        StringBuilder output = new StringBuilder();
        RequestProcessor.Task outTask = RP.post((Runnable)new Redirector(call.getInputStream(), output));
        if (!wait) {
            return null;
        }
        try {
            call.waitFor();
            errTask.waitFinished();
            outTask.waitFinished();
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
        if (executable.endsWith("ios-sim") && call.exitValue() > 0) {
            for (String p : parameters) {
                if (!p.endsWith("MobileSafari.app")) continue;
                throw new IllegalStateException();
            }
        }
        ProcessUtilities.logErr(error.toString());
        if (!error.toString().trim().isEmpty()) {
            LOGGER.warning(error.toString());
        }
        ProcessUtilities.logOut(output.toString());
        if (output.toString().isEmpty()) {
            LOGGER.severe("No output when executing " + executable + " " + Arrays.toString(parameters));
        }
        return output.toString();
    }

    static {
        boolean logger = Boolean.parseBoolean(System.getProperty("mobile.platforms.logger", "false"));
        if (logger) {
            io = IOProvider.getDefault().getIO("Mobile Platforms Logger", false);
        }
    }

    private static class Redirector
    implements Runnable {
        private final InputStream stream;
        private final StringBuilder output;

        private Redirector(InputStream stream, StringBuilder output) {
            this.stream = stream;
            this.output = output;
        }

        @Override
        public void run() {
            try (InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(this.stream));){
                char[] ch = new char[1];
                int number = inputStreamReader.read(ch);
                while (number > 0) {
                    this.output.append(ch);
                    number = inputStreamReader.read(ch);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

