/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.sharability;

import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.impl.sharability.ServerVolumeCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ServerLibraryTypeProvider
implements LibraryTypeProvider {
    public static final String LIBRARY_TYPE = "serverlibrary";
    public static final String VOLUME_CLASSPATH = "classpath";
    public static final String VOLUME_EMBEDDABLE_EJB_CLASSPATH = "embedabbleejb";
    public static final String VOLUME_WS_COMPILE_CLASSPATH = "wscompile";
    public static final String VOLUME_WS_GENERATE_CLASSPATH = "wsgenerate";
    public static final String VOLUME_WS_IMPORT_CLASSPATH = "wsimport";
    public static final String VOLUME_WS_INTEROP_CLASSPATH = "wsinterop";
    public static final String VOLUME_WS_JWSDP_CLASSPATH = "wsjwsdp";
    public static final String VOLUME_JAVADOC = "javadoc";
    public static final String VOLUME_SOURCE = "src";
    private static final String LIB_PREFIX = "libs.";
    private static final String[] VOLUME_TYPES = new String[]{"classpath", "embedabbleejb", "wscompile", "wsgenerate", "wsimport", "wsinterop", "wsjwsdp", "javadoc", "src"};

    private ServerLibraryTypeProvider() {
    }

    public static LibraryTypeProvider create() {
        return new ServerLibraryTypeProvider();
    }

    public LibraryImplementation createLibrary() {
        return LibrariesSupport.createLibraryImplementation((String)LIBRARY_TYPE, (String[])VOLUME_TYPES);
    }

    public Customizer getCustomizer(String volumeType) {
        if (VOLUME_CLASSPATH.equals(volumeType) || VOLUME_JAVADOC.equals(volumeType) || VOLUME_SOURCE.equals(volumeType)) {
            return new ServerVolumeCustomizer(volumeType);
        }
        return null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ServerLibraryTypeProvider.class, (String)"ServerLibraryTypeProvider.typeName");
    }

    public String getLibraryType() {
        return LIBRARY_TYPE;
    }

    public String[] getSupportedVolumeTypes() {
        return (String[])VOLUME_TYPES.clone();
    }

    public void libraryCreated(final LibraryImplementation libraryImpl) {
        assert (libraryImpl != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){
            final /* synthetic */ ServerLibraryTypeProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    boolean save = ServerLibraryTypeProvider.addLibraryIntoBuild(libraryImpl, props);
                    if (save) {
                        PropertyUtils.putGlobalProperties((EditableProperties)props);
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        });
    }

    public void libraryDeleted(final LibraryImplementation libraryImpl) {
        assert (libraryImpl != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){
            final /* synthetic */ ServerLibraryTypeProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    for (int i = 0; i < VOLUME_TYPES.length; ++i) {
                        String property = ServerLibraryTypeProvider.LIB_PREFIX + libraryImpl.getName() + '.' + VOLUME_TYPES[i];
                        props.remove((Object)property);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        });
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    private static boolean addLibraryIntoBuild(LibraryImplementation impl, EditableProperties props) {
        boolean modified = false;
        for (int i = 0; i < VOLUME_TYPES.length; ++i) {
            String propName = LIB_PREFIX + impl.getName() + '.' + VOLUME_TYPES[i];
            List roots = impl.getContent(VOLUME_TYPES[i]);
            if (roots == null) continue;
            StringBuffer propValue = new StringBuffer();
            boolean first = true;
            for (URL url : roots) {
                URI uri;
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                File f = null;
                FileObject fo = URLMapper.findFileObject((URL)url);
                if (fo != null) {
                    f = FileUtil.toFile((FileObject)fo);
                } else if ("file".equals(url.getProtocol()) && (uri = URI.create(url.toExternalForm())) != null) {
                    f = new File(uri);
                }
                if (f != null) {
                    if (!first) {
                        propValue.append(File.pathSeparatorChar);
                    }
                    first = false;
                    f = FileUtil.normalizeFile((File)f);
                    propValue.append(f.getAbsolutePath());
                    continue;
                }
                ErrorManager.getDefault().log("ServerLibraryTypeProvider: Can not resolve URL: " + url);
            }
            String oldValue = props.getProperty(propName);
            String newValue = propValue.toString();
            if (newValue.equals(oldValue)) continue;
            props.setProperty(propName, newValue);
            modified = true;
        }
        return modified;
    }
}

