/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.IgnoreRule;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public abstract class IgnoreUnignoreCommand
extends GitCommand {
    protected final File[] files;
    private final ProgressMonitor monitor;
    private final Set<File> ignoreFiles;
    private final FileListener listener;
    protected static final Logger LOG = Logger.getLogger(IgnoreUnignoreCommand.class.getName());

    public IgnoreUnignoreCommand(Repository repository, GitClassFactory gitFactory, File[] files, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.files = files;
        this.monitor = monitor;
        this.ignoreFiles = new LinkedHashSet<File>();
        this.listener = listener;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            String message = null;
            if (this.files.length == 0) {
                message = "Files to ignore must not be empty.";
            } else if (Arrays.asList(this.files).contains(this.getRepository().getWorkTree())) {
                message = "Cannot ignore working tree root.";
            }
            if (message != null) {
                this.monitor.preparationsFailed(message);
                throw new GitException(message);
            }
        }
        return retval;
    }

    @Override
    protected void run() {
        File workTree = this.getRepository().getWorkTree();
        for (int i = 0; i < this.files.length && !this.monitor.isCanceled(); ++i) {
            File f = this.files[i];
            try {
                this.changeIgnoreStatus(f);
                this.listener.notifyFile(f, Utils.getRelativePath(workTree, f));
                continue;
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                this.monitor.notifyError(ex.getLocalizedMessage());
            }
        }
    }

    private void changeIgnoreStatus(File f) throws IOException {
        File parent = f;
        boolean isDirectory = f.isDirectory() && !Files.isSymbolicLink(f.toPath());
        StringBuilder sb = new StringBuilder();
        if (isDirectory) {
            sb.append('/');
        }
        boolean cont = true;
        while (cont) {
            sb.insert(0, parent.getName()).insert(0, '/');
            parent = parent.getParentFile();
            String path = sb.toString();
            if (parent.equals(this.getRepository().getWorkTree())) {
                if (this.addStatement(new File(parent, ".gitignore"), path, isDirectory, false) && this.handleAdditionalIgnores(path, isDirectory)) {
                    this.addStatement(new File(parent, ".gitignore"), path, isDirectory, true);
                }
                cont = false;
                continue;
            }
            cont = this.addStatement(new File(parent, ".gitignore"), path, isDirectory, false);
        }
    }

    private boolean addStatement(File gitIgnore, String path, boolean isDirectory, boolean forceWrite) throws IOException {
        List<IgnoreRule> ignoreRules = this.parse(gitIgnore);
        return this.addStatement(ignoreRules, gitIgnore, path, isDirectory, forceWrite, true) == IgnoreNode.MatchResult.CHECK_PARENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void save(File gitIgnore, List<IgnoreRule> ignoreRules) throws IOException {
        try {
            Path tmpFile = Files.createTempFile(gitIgnore.getParentFile().toPath(), ".gitignore", "tmp", new FileAttribute[0]);
            try {
                String lineSeparator = IgnoreUnignoreCommand.probeLineSeparator(gitIgnore.toPath());
                try (BufferedWriter writer = Files.newBufferedWriter(tmpFile, new OpenOption[0]);){
                    for (IgnoreRule rule : ignoreRules) {
                        writer.write(rule.getPattern(false));
                        writer.write(lineSeparator);
                    }
                }
                Files.move(tmpFile, gitIgnore.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                Files.deleteIfExists(tmpFile);
            }
        }
        catch (IOException ex) {
            throw new IOException("Cannot update .gitignore at " + gitIgnore.getAbsolutePath(), ex);
        }
        this.ignoreFiles.add(gitIgnore);
    }

    private List<IgnoreRule> parse(File gitIgnore) throws IOException {
        if (gitIgnore.exists()) {
            try (Stream<String> lines = Files.lines(gitIgnore.toPath());){
                List list = lines.map(IgnoreRule::new).collect(Collectors.toCollection(LinkedList::new));
                return list;
            }
        }
        return new LinkedList<IgnoreRule>();
    }

    private static String probeLineSeparator(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader br = Files.newBufferedReader(file);){
                int current;
                int last = -1;
                while ((current = br.read()) != -1) {
                    if (current == 10) {
                        String string = last == 13 ? "\r\n" : "\n";
                        return string;
                    }
                    last = current;
                }
            }
        }
        return System.lineSeparator();
    }

    public File[] getModifiedIgnoreFiles() {
        return (File[])this.ignoreFiles.toArray(File[]::new);
    }

    protected abstract IgnoreNode.MatchResult addStatement(List<IgnoreRule> var1, File var2, String var3, boolean var4, boolean var5, boolean var6) throws IOException;

    protected static String escapeChars(String path) {
        return path.replace("[", "[[]").replace("*", "[*]").replace("?", "[?]");
    }

    protected final IgnoreNode.MatchResult checkExcludeFile(String path, boolean isDirectory) throws IOException {
        File excludeFile = new File(this.getRepository().getDirectory(), "info/exclude");
        List<IgnoreRule> ignoreRules = this.parse(excludeFile);
        return this.addStatement(ignoreRules, excludeFile, path, isDirectory, false, true);
    }

    protected final IgnoreNode.MatchResult checkGlobalExcludeFile(String path, boolean directory) throws IOException {
        File excludeFile = this.getGlobalExcludeFile();
        if (excludeFile != null && excludeFile.canRead()) {
            List<IgnoreRule> ignoreRules = this.parse(excludeFile);
            return this.addStatement(ignoreRules, excludeFile, path, directory, false, false);
        }
        return IgnoreNode.MatchResult.NOT_IGNORED;
    }

    private File getGlobalExcludeFile() {
        Repository repository = this.getRepository();
        String path = ((CoreConfig)repository.getConfig().get(CoreConfig.KEY)).getExcludesFile();
        File excludesfile = null;
        FS fs = repository.getFS();
        if (path != null) {
            excludesfile = path.startsWith("~/") ? fs.resolve(fs.userHome(), path.substring(2)) : fs.resolve(null, path);
        }
        return excludesfile;
    }

    protected abstract boolean handleAdditionalIgnores(String var1, boolean var2) throws IOException;
}

