/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.debugger.registry.ContextAwareServiceHandler;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class ContextAwareSupport {
    private ContextAwareSupport() {
    }

    public static Object createInstance(String service, ContextProvider context) {
        try {
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            String method = null;
            if (service.endsWith("()")) {
                int lastdot = service.lastIndexOf(46);
                if (lastdot < 0) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Bad service - dot before method name is missing: '" + service + "'."));
                    return null;
                }
                method = service.substring(lastdot + 1, service.length() - 2).trim();
                service = service.substring(0, lastdot);
            }
            Class<?> cls = cl.loadClass(service);
            Object o = null;
            if (method != null) {
                Method m = null;
                if (context != null) {
                    try {
                        m = cls.getDeclaredMethod(method, ContextProvider.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (m == null) {
                    try {
                        m = cls.getDeclaredMethod(method, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (m != null) {
                    Object[] objectArray;
                    if (m.getParameterTypes().length == 0) {
                        objectArray = new Object[]{};
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = context;
                    }
                    o = m.invoke(null, objectArray);
                }
            }
            if (o == null && context != null) {
                for (Constructor<?> c : cls.getConstructors()) {
                    if (c.getParameterTypes().length != 1 || !ContextProvider.class.isAssignableFrom(c.getParameterTypes()[0])) continue;
                    try {
                        o = c.newInstance(context);
                    }
                    catch (IllegalAccessException e) {
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("service: " + service)));
                    }
                    catch (IllegalArgumentException e) {
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("service: " + service)));
                    }
                }
            }
            if (o == null) {
                o = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (Logger.getLogger(ContextAwareSupport.class.getName()).isLoggable(Level.FINE)) {
                Logger.getLogger(ContextAwareSupport.class.getName()).fine("instance " + String.valueOf(o) + " created.");
            }
            return o;
        }
        catch (ClassNotFoundException e) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("The service " + service + " not found.")));
        }
        catch (InstantiationException | NoSuchMethodException e) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("The service " + service + " can not be instantiated. Context = " + String.valueOf(context))));
        }
        catch (IllegalAccessException e) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("The service " + service + " can not be accessed. Context = " + String.valueOf(context))));
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof ThreadDeath) {
                throw (ThreadDeath)ex.getCause();
            }
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("The service " + service + " can not be created. Context = " + String.valueOf(context))));
        }
        catch (ExceptionInInitializerError ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("The service " + service + " can not be initialized. Context = " + String.valueOf(context))));
        }
        return null;
    }

    static ContextAwareService createService(Map attrs) throws ClassNotFoundException {
        String serviceName = (String)attrs.get("serviceName");
        String serviceClasses = (String)attrs.get("serviceClasses");
        if (serviceClasses == null) {
            serviceClasses = (String)attrs.get("instanceOf");
        }
        String[] serviceClassNames = ContextAwareSupport.splitClasses(serviceClasses);
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        Class[] classes = new Class[serviceClassNames.length + 1];
        classes[0] = ContextAwareService.class;
        for (int i = 0; i < serviceClassNames.length; ++i) {
            classes[i + 1] = Class.forName(serviceClassNames[i], true, cl);
        }
        return (ContextAwareService)Proxy.newProxyInstance(cl, classes, (InvocationHandler)new ContextAwareServiceHandler(serviceName, classes, Collections.emptyMap()));
    }

    private static String[] splitClasses(String classes) {
        return classes.split("[, ]+");
    }
}

