/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.modules.project.dependency.impl.ProjectModificationResultImpl;
import org.netbeans.modules.project.dependency.impl.WorkspaceEditAdapter;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.openide.filesystems.FileObject;

public final class ProjectModificationResult
implements ModificationResult {
    private ProjectModificationResultImpl impl;
    private WorkspaceEditAdapter wrapEdits;

    ProjectModificationResult(ProjectModificationResultImpl impl) {
        this.impl = impl;
    }

    public Collection<FileObject> getFilesToSave() {
        return this.impl.getFilesToSave();
    }

    public WorkspaceEdit getWorkspaceEdit() {
        return this.impl.getWorkspaceEdit();
    }

    public String getResultingSource(FileObject file) throws IOException, IllegalArgumentException {
        return this.wrapEdits().getResultingSource(file);
    }

    WorkspaceEditAdapter wrapEdits() {
        if (this.wrapEdits == null) {
            this.wrapEdits = new WorkspaceEditAdapter(this.impl);
        }
        return this.wrapEdits;
    }

    public Collection<? extends FileObject> getModifiedFileObjects() {
        LinkedHashSet<? extends FileObject> modified = new LinkedHashSet<FileObject>();
        modified.addAll(this.wrapEdits().getModifiedFileObjects());
        ModificationResult custom = this.impl.getCustomEdit();
        if (custom != null) {
            modified.addAll(custom.getModifiedFileObjects());
        }
        return modified;
    }

    public Collection<? extends File> getNewFiles() {
        LinkedHashSet<? extends File> r = new LinkedHashSet<File>();
        r.addAll(this.wrapEdits().getNewFiles());
        ModificationResult custom = this.impl.getCustomEdit();
        if (custom != null) {
            r.addAll(custom.getNewFiles());
        }
        return r;
    }

    public void commit() throws IOException {
        WorkspaceEditAdapter r = this.wrapEdits();
        r.commit();
        if (this.impl.getCustomEdit() != null) {
            this.impl.getCustomEdit().commit();
        }
        for (FileObject f : r.getFilesToSave()) {
            Savable s = (Savable)f.getLookup().lookup(Savable.class);
            if (s == null) continue;
            s.save();
        }
    }
}

