/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AppCatalogListing
extends ExplicitlySetBmcModel {
    @JsonProperty(value="contactUrl")
    private final String contactUrl;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="listingId")
    private final String listingId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timePublished")
    private final Date timePublished;
    @JsonProperty(value="publisherLogoUrl")
    private final String publisherLogoUrl;
    @JsonProperty(value="publisherName")
    private final String publisherName;
    @JsonProperty(value="summary")
    private final String summary;

    @Deprecated
    @ConstructorProperties(value={"contactUrl", "description", "listingId", "displayName", "timePublished", "publisherLogoUrl", "publisherName", "summary"})
    public AppCatalogListing(String contactUrl, String description, String listingId, String displayName, Date timePublished, String publisherLogoUrl, String publisherName, String summary) {
        this.contactUrl = contactUrl;
        this.description = description;
        this.listingId = listingId;
        this.displayName = displayName;
        this.timePublished = timePublished;
        this.publisherLogoUrl = publisherLogoUrl;
        this.publisherName = publisherName;
        this.summary = summary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getContactUrl() {
        return this.contactUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimePublished() {
        return this.timePublished;
    }

    public String getPublisherLogoUrl() {
        return this.publisherLogoUrl;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppCatalogListing(");
        sb.append("super=").append(super.toString());
        sb.append("contactUrl=").append(String.valueOf(this.contactUrl));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", listingId=").append(String.valueOf(this.listingId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timePublished=").append(String.valueOf(this.timePublished));
        sb.append(", publisherLogoUrl=").append(String.valueOf(this.publisherLogoUrl));
        sb.append(", publisherName=").append(String.valueOf(this.publisherName));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppCatalogListing)) {
            return false;
        }
        AppCatalogListing other = (AppCatalogListing)((Object)o);
        return Objects.equals(this.contactUrl, other.contactUrl) && Objects.equals(this.description, other.description) && Objects.equals(this.listingId, other.listingId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timePublished, other.timePublished) && Objects.equals(this.publisherLogoUrl, other.publisherLogoUrl) && Objects.equals(this.publisherName, other.publisherName) && Objects.equals(this.summary, other.summary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.contactUrl == null ? 43 : this.contactUrl.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timePublished == null ? 43 : this.timePublished.hashCode());
        result = result * 59 + (this.publisherLogoUrl == null ? 43 : this.publisherLogoUrl.hashCode());
        result = result * 59 + (this.publisherName == null ? 43 : this.publisherName.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="contactUrl")
        private String contactUrl;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="listingId")
        private String listingId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timePublished")
        private Date timePublished;
        @JsonProperty(value="publisherLogoUrl")
        private String publisherLogoUrl;
        @JsonProperty(value="publisherName")
        private String publisherName;
        @JsonProperty(value="summary")
        private String summary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder contactUrl(String contactUrl) {
            this.contactUrl = contactUrl;
            this.__explicitlySet__.add("contactUrl");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            this.__explicitlySet__.add("listingId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timePublished(Date timePublished) {
            this.timePublished = timePublished;
            this.__explicitlySet__.add("timePublished");
            return this;
        }

        public Builder publisherLogoUrl(String publisherLogoUrl) {
            this.publisherLogoUrl = publisherLogoUrl;
            this.__explicitlySet__.add("publisherLogoUrl");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.__explicitlySet__.add("publisherName");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public AppCatalogListing build() {
            AppCatalogListing model = new AppCatalogListing(this.contactUrl, this.description, this.listingId, this.displayName, this.timePublished, this.publisherLogoUrl, this.publisherName, this.summary);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AppCatalogListing model) {
            if (model.wasPropertyExplicitlySet("contactUrl")) {
                this.contactUrl(model.getContactUrl());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("listingId")) {
                this.listingId(model.getListingId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timePublished")) {
                this.timePublished(model.getTimePublished());
            }
            if (model.wasPropertyExplicitlySet("publisherLogoUrl")) {
                this.publisherLogoUrl(model.getPublisherLogoUrl());
            }
            if (model.wasPropertyExplicitlySet("publisherName")) {
                this.publisherName(model.getPublisherName());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            return this;
        }
    }
}

