/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TunnelRouteSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="prefix")
    private final String prefix;
    @JsonProperty(value="age")
    private final Long age;
    @JsonProperty(value="isBestPath")
    private final Boolean isBestPath;
    @JsonProperty(value="asPath")
    private final List<Integer> asPath;
    @JsonProperty(value="advertiser")
    private final Advertiser advertiser;

    @Deprecated
    @ConstructorProperties(value={"prefix", "age", "isBestPath", "asPath", "advertiser"})
    public TunnelRouteSummary(String prefix, Long age, Boolean isBestPath, List<Integer> asPath, Advertiser advertiser) {
        this.prefix = prefix;
        this.age = age;
        this.isBestPath = isBestPath;
        this.asPath = asPath;
        this.advertiser = advertiser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Long getAge() {
        return this.age;
    }

    public Boolean getIsBestPath() {
        return this.isBestPath;
    }

    public List<Integer> getAsPath() {
        return this.asPath;
    }

    public Advertiser getAdvertiser() {
        return this.advertiser;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TunnelRouteSummary(");
        sb.append("super=").append(super.toString());
        sb.append("prefix=").append(String.valueOf(this.prefix));
        sb.append(", age=").append(String.valueOf(this.age));
        sb.append(", isBestPath=").append(String.valueOf(this.isBestPath));
        sb.append(", asPath=").append(String.valueOf(this.asPath));
        sb.append(", advertiser=").append(String.valueOf((Object)this.advertiser));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TunnelRouteSummary)) {
            return false;
        }
        TunnelRouteSummary other = (TunnelRouteSummary)((Object)o);
        return Objects.equals(this.prefix, other.prefix) && Objects.equals(this.age, other.age) && Objects.equals(this.isBestPath, other.isBestPath) && Objects.equals(this.asPath, other.asPath) && Objects.equals((Object)this.advertiser, (Object)other.advertiser) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.prefix == null ? 43 : this.prefix.hashCode());
        result = result * 59 + (this.age == null ? 43 : this.age.hashCode());
        result = result * 59 + (this.isBestPath == null ? 43 : this.isBestPath.hashCode());
        result = result * 59 + (this.asPath == null ? 43 : this.asPath.hashCode());
        result = result * 59 + (this.advertiser == null ? 43 : this.advertiser.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Advertiser implements BmcEnum
    {
        Customer("CUSTOMER"),
        Oracle("ORACLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Advertiser> map;

        private Advertiser(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Advertiser create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Advertiser', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Advertiser.class);
            map = new HashMap<String, Advertiser>();
            for (Advertiser v : Advertiser.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="prefix")
        private String prefix;
        @JsonProperty(value="age")
        private Long age;
        @JsonProperty(value="isBestPath")
        private Boolean isBestPath;
        @JsonProperty(value="asPath")
        private List<Integer> asPath;
        @JsonProperty(value="advertiser")
        private Advertiser advertiser;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.__explicitlySet__.add("prefix");
            return this;
        }

        public Builder age(Long age) {
            this.age = age;
            this.__explicitlySet__.add("age");
            return this;
        }

        public Builder isBestPath(Boolean isBestPath) {
            this.isBestPath = isBestPath;
            this.__explicitlySet__.add("isBestPath");
            return this;
        }

        public Builder asPath(List<Integer> asPath) {
            this.asPath = asPath;
            this.__explicitlySet__.add("asPath");
            return this;
        }

        public Builder advertiser(Advertiser advertiser) {
            this.advertiser = advertiser;
            this.__explicitlySet__.add("advertiser");
            return this;
        }

        public TunnelRouteSummary build() {
            TunnelRouteSummary model = new TunnelRouteSummary(this.prefix, this.age, this.isBestPath, this.asPath, this.advertiser);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TunnelRouteSummary model) {
            if (model.wasPropertyExplicitlySet("prefix")) {
                this.prefix(model.getPrefix());
            }
            if (model.wasPropertyExplicitlySet("age")) {
                this.age(model.getAge());
            }
            if (model.wasPropertyExplicitlySet("isBestPath")) {
                this.isBestPath(model.getIsBestPath());
            }
            if (model.wasPropertyExplicitlySet("asPath")) {
                this.asPath(model.getAsPath());
            }
            if (model.wasPropertyExplicitlySet("advertiser")) {
                this.advertiser(model.getAdvertiser());
            }
            return this;
        }
    }
}

