/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.exec;

import java.awt.EventQueue;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.GruntBuildTool;
import org.netbeans.modules.javascript.grunt.exec.Bundle;
import org.netbeans.modules.javascript.grunt.options.GruntOptions;
import org.netbeans.modules.javascript.grunt.options.GruntOptionsValidator;
import org.netbeans.modules.javascript.grunt.util.GruntUtils;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class GruntExecutable {
    static final Logger LOGGER = Logger.getLogger(GruntExecutable.class.getName());
    public static final String GRUNT_NAME = Utilities.isWindows() ? "grunt.cmd" : "grunt";
    private static final String HELP_PARAM = "--help";
    private static final String NO_COLOR_PARAM = "--no-color";
    private static final String TASKS_PARAM = "--tasks";
    protected final Project project;
    protected final String gruntPath;
    private final List<String> tasks;
    @NullAllowed
    private final File workDir;

    GruntExecutable(String gruntPath, Project project, @NullAllowed File workDir) {
        assert (gruntPath != null);
        assert (project != null);
        this.gruntPath = gruntPath;
        this.tasks = this.getTasks(project, workDir);
        this.project = project;
        this.workDir = workDir;
    }

    @CheckForNull
    public static GruntExecutable getDefault(Project project, boolean showOptions) {
        return GruntExecutable.createExecutable(project, null, showOptions);
    }

    @CheckForNull
    public static GruntExecutable getDefault(Project project, File workDir, boolean showOptions) {
        assert (workDir != null);
        assert (workDir.exists()) : workDir;
        return GruntExecutable.createExecutable(project, workDir, showOptions);
    }

    @CheckForNull
    private static GruntExecutable createExecutable(Project project, @NullAllowed File workDir, boolean showOptions) {
        assert (project != null);
        ValidationResult result = new GruntOptionsValidator().validateGrunt().getResult();
        if (GruntExecutable.validateResult(result) != null) {
            if (showOptions) {
                OptionsDisplayer.getDefault().open("Html5/Grunt");
            }
            return null;
        }
        String grunt = GruntOptions.getInstance().getGrunt();
        if (Utilities.isMac()) {
            return new MacGruntExecutable(grunt, project, workDir);
        }
        return new GruntExecutable(grunt, project, workDir);
    }

    String getCommand() {
        return this.gruntPath;
    }

    public Future<Integer> run(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = GruntUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.GruntExecutable_run(projectName)).additionalParameters(this.getRunParams(args)).run(this.getDescriptor());
        assert (task != null) : this.gruntPath;
        return task;
    }

    public Future<List<String>> listTasks() {
        final GruntTasksLineProcessor gruntTasksLineProcessor = new GruntTasksLineProcessor();
        Future task = this.getExecutable("list grunt tasks").noInfo(true).additionalParameters(this.getParams(GruntExecutable.getListTasksParams())).redirectErrorStream(false).run(GruntExecutable.getSilentDescriptor(), new ExecutionDescriptor.InputProcessorFactory2(){
            final /* synthetic */ GruntExecutable this$0;
            {
                this.this$0 = this$0;
            }

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.bridge((LineProcessor)gruntTasksLineProcessor);
            }
        });
        assert (task != null) : this.gruntPath;
        return new TaskList(this, task, gruntTasksLineProcessor);
    }

    private ExternalExecutable getExecutable(String title) {
        assert (title != null);
        return new ExternalExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsPath("Html5/Grunt").noOutput(false);
    }

    private ExecutionDescriptor getDescriptor() {
        assert (this.project != null);
        return ExternalExecutable.DEFAULT_EXECUTION_DESCRIPTOR.showSuspended(true).optionsPath("Html5/Grunt").outLineBased(true).errLineBased(true).postExecution(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])new File[]{GruntExecutable.this.getWorkDir()});
            }
        });
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false).charset(StandardCharsets.UTF_8).outLineBased(true);
    }

    private File getWorkDir() {
        if (this.workDir != null && this.workDir.exists()) {
            return this.workDir;
        }
        File dir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (dir != null) : this.project.getProjectDirectory();
        return dir;
    }

    private List<String> getRunParams(String ... args) {
        return this.getParams(Arrays.asList(args));
    }

    List<String> getParams(List<String> params) {
        assert (params != null);
        ArrayList<String> allParams = new ArrayList<String>(this.tasks.size() * 2 + params.size());
        for (String task : this.tasks) {
            allParams.add(TASKS_PARAM);
            allParams.add(task.trim());
        }
        allParams.addAll(params);
        return allParams;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstErrorMessage();
        }
        return result.getFirstWarningMessage();
    }

    static List<String> getListTasksParams() {
        return Arrays.asList(NO_COLOR_PARAM, HELP_PARAM);
    }

    private List<String> getTasks(Project project, @NullAllowed File workDir) {
        if (workDir == null || workDir.equals(FileUtil.toFile((FileObject)project.getProjectDirectory()))) {
            return StringUtilities.explode((String)GruntBuildTool.forProject(project).getGruntPreferences().getTasks(), (String)",");
        }
        return Collections.emptyList();
    }

    private static final class MacGruntExecutable
    extends GruntExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacGruntExecutable(String gruntPath, Project project, File workDir) {
            super(gruntPath, project, workDir);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getParams(List<String> params) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.gruntPath);
            sb.append("\" \"");
            sb.append(StringUtilities.implode(super.getParams(params), (String)"\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }

    static final class GruntTasksLineProcessor
    implements LineProcessor {
        private static final String AVAILABLE_TASKS = "Available tasks";
        private static final String NO_TASKS = "(no tasks found)";
        final List<String> tasks = new ArrayList<String>();
        private volatile int state = 0;
        private int spaceIndex = -1;

        GruntTasksLineProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            LOGGER.log(Level.FINE, line);
            switch (this.state) {
                case 0: {
                    if (!AVAILABLE_TASKS.equals(line)) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    String task;
                    if (!StringUtilities.hasText((String)line)) {
                        this.state = 2;
                        break;
                    }
                    if (NO_TASKS.equals(line.trim())) {
                        this.state = 2;
                        break;
                    }
                    if (this.spaceIndex == -1) {
                        task = (String)StringUtilities.explode((String)line.trim(), (String)"  ").get(0);
                        assert (StringUtilities.hasText((String)task)) : line;
                        this.spaceIndex = line.indexOf(task) + task.length();
                    }
                    if (!StringUtilities.hasText((String)(task = line.substring(0, this.spaceIndex).trim()))) break;
                    List<String> list = this.tasks;
                    synchronized (list) {
                        this.tasks.add(task);
                        break;
                    }
                }
            }
        }

        public void reset() {
        }

        public void close() {
        }

        public boolean errorOccurred() {
            return this.state == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getTasks() {
            List<String> list = this.tasks;
            synchronized (list) {
                return new ArrayList<String>(this.tasks);
            }
        }
    }

    private static final class TaskList
    implements Future<List<String>> {
        private static final RequestProcessor RP = new RequestProcessor(TaskList.class);
        final GruntExecutable grunt;
        private final Future<Integer> task;
        private final GruntTasksLineProcessor convertor;
        private List<String> gruntTasks = null;

        TaskList(GruntExecutable grunt, Future<Integer> task, GruntTasksLineProcessor convertor) {
            assert (grunt != null);
            assert (task != null);
            assert (convertor != null);
            this.grunt = grunt;
            this.task = task;
            this.convertor = convertor;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                this.task.get();
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getGruntTasks();
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                this.task.get(timeout, unit);
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getGruntTasks();
        }

        private synchronized List<String> getGruntTasks() {
            if (this.gruntTasks != null) {
                return Collections.unmodifiableList(this.gruntTasks);
            }
            if (this.convertor.errorOccurred()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        grunt.run(GruntExecutable.getListTasksParams().toArray(new String[0]));
                    }
                });
                StatusDisplayer.getDefault().setStatusText(Bundle.TaskList_error());
                this.gruntTasks = Collections.emptyList();
                return Collections.unmodifiableList(this.gruntTasks);
            }
            ArrayList<String> tasks = new ArrayList<String>(this.convertor.getTasks());
            Collections.sort(tasks);
            this.gruntTasks = new CopyOnWriteArrayList<String>(tasks);
            return Collections.unmodifiableList(this.gruntTasks);
        }
    }
}

