/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateFluent;
import io.fabric8.kubernetes.api.model.ContainerStateFluentImpl;

public class ContainerStateBuilder
extends ContainerStateFluentImpl<ContainerStateBuilder>
implements VisitableBuilder<ContainerState, ContainerStateBuilder> {
    ContainerStateFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStateBuilder() {
        this(false);
    }

    public ContainerStateBuilder(Boolean validationEnabled) {
        this(new ContainerState(), validationEnabled);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerState(), validationEnabled);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance) {
        this(fluent, instance, false);
    }

    public ContainerStateBuilder(ContainerStateFluent<?> fluent, ContainerState instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withRunning(instance.getRunning());
            fluent.withTerminated(instance.getTerminated());
            fluent.withWaiting(instance.getWaiting());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ContainerStateBuilder(ContainerState instance) {
        this(instance, (Boolean)false);
    }

    public ContainerStateBuilder(ContainerState instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withRunning(instance.getRunning());
            this.withTerminated(instance.getTerminated());
            this.withWaiting(instance.getWaiting());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerState build() {
        ContainerState buildable = new ContainerState(this.fluent.getRunning(), this.fluent.getTerminated(), this.fluent.getWaiting());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

