/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.jsf.hints.JsfHintsContext;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;

public class JsfHintsUtils {
    private static final Logger LOG = Logger.getLogger(JsfHintsUtils.class.getName());
    private static final String CACHED_CONTEXT = "cached-jsfProblemContext";

    public static JsfHintsContext getOrCacheContext(HintContext context) {
        Object cached = context.getInfo().getCachedValue((Object)CACHED_CONTEXT);
        if (cached == null) {
            LOG.log(Level.FINEST, "HintContext doesn't contain cached JsfHintsContext which is going to be created.");
            JsfHintsContext newContext = JsfHintsUtils.createJsfHintsContext(context);
            context.getInfo().putCachedValue((Object)CACHED_CONTEXT, (Object)newContext, CompilationInfo.CacheClearPolicy.ON_SIGNATURE_CHANGE);
            return newContext;
        }
        LOG.log(Level.FINEST, "JsfHintsContext cached value used.");
        return (JsfHintsContext)cached;
    }

    private static JsfHintsContext createJsfHintsContext(HintContext context) {
        return new JsfHintsContext(context.getInfo().getFileObject());
    }

    public static ErrorDescription createProblem(Tree tree, CompilationInfo cinfo, String description, Severity severity, List<Fix> fixes) {
        TextSpan underlineSpan = JsfHintsUtils.getUnderlineSpan(cinfo, tree);
        return ErrorDescriptionFactory.createErrorDescription((Severity)severity, (String)description, fixes, (FileObject)cinfo.getFileObject(), (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset());
    }

    public static TextSpan getUnderlineSpan(CompilationInfo info, Tree tree) {
        SourcePositions srcPos = info.getTrees().getSourcePositions();
        int startOffset = (int)srcPos.getStartPosition(info.getCompilationUnit(), tree);
        int endOffset = (int)srcPos.getEndPosition(info.getCompilationUnit(), tree);
        return new TextSpan(startOffset, endOffset);
    }

    public static class TextSpan {
        private int startOffset;
        private int endOffset;

        public TextSpan(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

