/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.env;

import java.io.IOException;
import org.netbeans.modules.jshell.editor.ConsoleEditor;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.env.ShellRegistry;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Task;
import org.openide.windows.CloneableOpenSupport;

class JShellDataObject
extends MultiDataObject {
    public JShellDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        CookieSet cks = this.getCookieSet();
        cks.add(new Class[]{OpenCookie.class, EditorCookie.Observable.class, CloseCookie.class, LineCookie.class, SimpleES.class}, new CookieSet.Factory(){
            private CloneableEditorSupport supp;

            public <T extends Node.Cookie> T createCookie(Class<T> klass) {
                if (this.supp != null) {
                    return (T)((Node.Cookie)klass.cast(this.supp));
                }
                this.supp = new SimpleES((DataObject)JShellDataObject.this, JShellDataObject.this.getPrimaryEntry());
                return (T)((Node.Cookie)klass.cast(this.supp));
            }
        });
    }

    private CloneableEditorSupport.Pane createPane0() {
        CloneableEditorSupport cls = (CloneableEditorSupport)this.getLookup().lookup(EditorCookie.class);
        ConsoleEditor cle = new ConsoleEditor(cls, this.getLookup());
        return cle;
    }

    public void setModified(boolean modif) {
    }

    public void reload() throws IOException {
        FileLock fl = this.getPrimaryFile().lock();
        try {
            this.getPrimaryFile().getOutputStream(fl).close();
        }
        finally {
            fl.releaseLock();
        }
        SimpleES es = (SimpleES)((Object)this.getLookup().lookup(SimpleES.class));
        if (es != null) {
            es.reloadDocument();
        }
    }

    public final class SimpleES
    extends DataEditorSupport
    implements OpenCookie,
    EditCookie,
    EditorCookie.Observable,
    PrintCookie,
    CloseCookie,
    SaveAsCapable,
    LineCookie {
        public SimpleES(DataObject obj, MultiDataObject.Entry entry) {
            super(obj, obj.getLookup(), (CloneableEditorSupport.Env)new ESEnv(obj, entry));
        }

        protected boolean asynchronousOpen() {
            return true;
        }

        protected CloneableEditorSupport.Pane createPane() {
            return JShellDataObject.this.createPane0();
        }

        protected boolean notifyModified() {
            return true;
        }

        protected void notifyUnmodified() {
        }

        protected String messageHtmlName() {
            JShellEnvironment env = ShellRegistry.get().get(JShellDataObject.this.getPrimaryFile());
            if (env == null) {
                return super.messageHtmlName();
            }
            return env.getDisplayName();
        }

        protected String messageName() {
            return super.messageName();
        }

        public Task reloadDocument() {
            return super.reloadDocument();
        }
    }

    private static class ESEnv
    extends DataEditorSupport.Env {
        private MultiDataObject.Entry entry;

        public ESEnv(DataObject obj, MultiDataObject.Entry entry) {
            super(obj);
            this.entry = entry;
        }

        protected FileObject getFile() {
            return this.entry.getFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.entry.takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(SimpleES.class);
        }
    }
}

