/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.maven;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jshell.project.JShellOptions2;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MavenRunOptions
extends JPanel
implements HelpCtx.Provider {
    private final Project project;
    private final ModelHandle2 handle;
    private final ProjectCustomizer.Category category;
    private JShellOptions2 nestedOptions;
    private NetbeansActionMapping run;
    private NetbeansActionMapping debug;
    private JComboBox cbConfiguration;
    private JPanel detailPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel pOptions;

    public MavenRunOptions(Project project, ProjectCustomizer.Category category, final ModelHandle2 handle) {
        this.project = project;
        this.category = category;
        this.handle = handle;
        this.initComponents();
        this.cbConfiguration.setEditable(false);
        this.cbConfiguration.setRenderer(new DefaultListCellRenderer(this){
            final /* synthetic */ MavenRunOptions this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component com = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (com instanceof JLabel && value == handle.getActiveConfiguration()) {
                    com.setFont(com.getFont().deriveFont(1));
                }
                return com;
            }
        });
        this.nestedOptions = (JShellOptions2)this.pOptions;
        this.setupConfigurations();
        this.loadOptions(null);
        this.nestedOptions.setConfigChangeListener(this::optionsChanged);
        this.cbConfiguration.addActionListener(this::loadOptions);
    }

    private void loadOptions(ActionEvent e) {
        ActionToGoalMapping mapp = this.handle.getActionMappings((ModelHandle2.Configuration)this.cbConfiguration.getSelectedItem());
        List lst = mapp.getActions();
        this.run = null;
        this.debug = null;
        for (NetbeansActionMapping m : lst) {
            if ("run".equals(m.getActionName())) {
                this.run = m;
            }
            if (!"debug".equals(m.getActionName())) continue;
            this.debug = m;
        }
        if (this.run == null) {
            this.run = ModelHandle2.getDefaultMapping((String)"run", (Project)this.project);
        }
        if (this.debug == null) {
            this.debug = ModelHandle2.getDefaultMapping((String)"debug", (Project)this.project);
        }
        CardLayout cl = (CardLayout)this.detailPanel.getLayout();
        if (this.run == null) {
            cl.show(this.detailPanel, "disabled");
        } else {
            this.nestedOptions.readOptions(this.run.getProperties());
            cl.show(this.detailPanel, "jshell");
        }
    }

    private boolean updateMessage() {
        if (!this.nestedOptions.isPanelValid()) {
            this.category.setErrorMessage(this.nestedOptions.getErrorMessage());
            return true;
        }
        this.category.setErrorMessage(null);
        return false;
    }

    private void optionsChanged(ChangeEvent e) {
        if (this.updateMessage()) {
            return;
        }
        if (this.run == null) {
            return;
        }
        ActionToGoalMapping a2gm = this.handle.getActionMappings((ModelHandle2.Configuration)this.cbConfiguration.getSelectedItem());
        this.changeConfiguration(this.run, a2gm);
        this.changeConfiguration(this.debug, a2gm);
        this.handle.markAsModified(a2gm);
    }

    private void changeConfiguration(NetbeansActionMapping am, ActionToGoalMapping a2gm) {
        if (am == null) {
            return;
        }
        Map<String, String> opts = this.nestedOptions.getChangedOptions();
        for (Map.Entry<String, String> entry : opts.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (v != null) {
                am.addProperty(k, v);
                continue;
            }
            am.getProperties().remove(k);
        }
        ModelHandle2.setUserActionMapping((NetbeansActionMapping)am, (ActionToGoalMapping)a2gm);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("maven_jshell_run");
    }

    private void setupConfigurations() {
        DefaultComboBoxModel<ModelHandle2.Configuration> comModel = new DefaultComboBoxModel<ModelHandle2.Configuration>();
        for (ModelHandle2.Configuration conf : this.handle.getConfigurations()) {
            comModel.addElement(conf);
        }
        this.cbConfiguration.setModel(comModel);
        this.cbConfiguration.setSelectedItem(this.handle.getActiveConfiguration());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbConfiguration = new JComboBox();
        this.detailPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.pOptions = new JShellOptions2(this.project);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MavenRunOptions.class, (String)"MavenRunOptions.jLabel1.text"));
        this.detailPanel.setLayout(new CardLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MavenRunOptions.class, (String)"MavenRunOptions.jLabel2.text"));
        this.jLabel2.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 492, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 115, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE))));
        this.detailPanel.add((Component)this.jPanel1, "disabled");
        this.detailPanel.add((Component)this.pOptions, "jshell");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.detailPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbConfiguration, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbConfiguration, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.detailPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

