/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateAttributes;
import org.netbeans.modules.java.api.common.queries.QuerySupport;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public final class CreateFromTemplateAttributesImpl
implements CreateFromTemplateAttributes {
    private static final Logger LOGGER = Logger.getLogger(CreateFromTemplateAttributesImpl.class.getName());
    private final AntProjectHelper helper;
    private final CreateFromTemplateAttributesProvider delegate;

    CreateFromTemplateAttributesImpl(AntProjectHelper helper, FileEncodingQueryImplementation encodingQuery) {
        assert (helper != null);
        assert (encodingQuery != null);
        this.helper = helper;
        this.delegate = QuerySupport.createTemplateAttributesProvider((AntProjectHelper)helper, (FileEncodingQueryImplementation)encodingQuery);
    }

    public Map<String, ?> attributesFor(CreateDescriptor desc) {
        try {
            HashMap<String, String> projectValues;
            HashMap values = this.delegate.attributesFor(DataObject.find((FileObject)desc.getTemplate()), DataFolder.findFolder((FileObject)desc.getTarget()), desc.getName());
            if (values == null) {
                values = new HashMap();
            }
            if ((projectValues = (HashMap<String, String>)values.get("project")) == null) {
                projectValues = new HashMap<String, String>();
                values.put("project", projectValues);
            }
            Project prj = ProjectManager.getDefault().findProject(this.helper.getProjectDirectory());
            assert (prj != null);
            projectValues.put("webRootPath", CreateFromTemplateAttributesImpl.getWebRootPath(prj));
            return values;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    @CheckForNull
    private static String getWebRootPath(Project project) {
        Iterator iterator = ProjectWebRootQuery.getWebRoots((Project)project).iterator();
        if (iterator.hasNext()) {
            FileObject webRoot = (FileObject)iterator.next();
            return FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)webRoot);
        }
        return null;
    }
}

