/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.nodes.actions.OpenURLActionCookie;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenTestURLAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        for (Node node : nodes) {
            OpenURLActionCookie oCookie = (OpenURLActionCookie)node.getCookie(OpenURLActionCookie.class);
            if (oCookie == null) continue;
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(oCookie.getWebURL()));
            }
            catch (MalformedURLException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        for (Node node : nodes) {
            OpenURLActionCookie oCookie = (OpenURLActionCookie)node.getCookie(OpenURLActionCookie.class);
            if (oCookie == null || oCookie.getWebURL() == null) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(OpenTestURLAction.class, (String)"LBL_OpenTestUrlAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

