/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.netbeans.modules.mylyn.util.NbTask;

public final class UnsubmittedTasksContainer {
    private final TaskRepository repository;
    private final Set<NbTask> tasks = Collections.synchronizedSet(new LinkedHashSet());
    private final PropertyChangeSupport support;
    public static final String EVENT_ISSUES_CHANGED = "mylyn.unsubmitted_tasks.changed";
    private static final Logger LOG = Logger.getLogger(UnsubmittedTasksContainer.class.getName());
    private final TaskList taskList;
    private final MylynSupport supp = MylynSupport.getInstance();
    private TaskListListener list;

    UnsubmittedTasksContainer(TaskRepository repository, TaskList taskList) {
        this.repository = repository;
        this.taskList = taskList;
        this.support = new PropertyChangeSupport(this);
        this.initialize();
    }

    public List<NbTask> getTasks() {
        return new ArrayList<NbTask>(this.tasks);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private void fireIssuesChanged() {
        this.support.firePropertyChange(EVENT_ISSUES_CHANGED, null, null);
    }

    private void initialize() {
        try {
            this.taskList.run(new ITaskListRunnable(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    UnsubmittedTasksContainer.this.taskList.addChangeListener((ITaskListChangeListener)(UnsubmittedTasksContainer.this.list = new TaskListListener()));
                    UnsubmittedTasksContainer.this.tasks.addAll(UnsubmittedTasksContainer.this.supp.toNbTasks(UnsubmittedTasksContainer.this.taskList.getUnsubmittedContainer(UnsubmittedTasksContainer.this.repository.getRepositoryUrl()).getChildren()));
                    for (NbTask task : UnsubmittedTasksContainer.this.supp.getTasks(UnsubmittedTasksContainer.this.repository)) {
                        if (!task.isOutgoing()) continue;
                        UnsubmittedTasksContainer.this.tasks.add(task);
                    }
                }
            });
        }
        catch (CoreException ex) {
            LOG.log(Level.INFO, null, ex);
        }
    }

    private class TaskListListener
    implements ITaskListChangeListener {
        private TaskListListener() {
        }

        public void containersChanged(Set<TaskContainerDelta> deltas) {
            boolean change = false;
            for (TaskContainerDelta delta : deltas) {
                if (!(delta.getElement() instanceof ITask)) continue;
                ITask task = (ITask)delta.getElement();
                NbTask nbTask = UnsubmittedTasksContainer.this.supp.toNbTask(task);
                if (delta.getKind() == TaskContainerDelta.Kind.CONTENT) {
                    if (!UnsubmittedTasksContainer.this.repository.getRepositoryUrl().equals(task.getRepositoryUrl())) continue;
                    change |= nbTask.isOutgoing() ? UnsubmittedTasksContainer.this.tasks.add(nbTask) : UnsubmittedTasksContainer.this.tasks.remove(nbTask);
                    continue;
                }
                if (delta.getKind() == TaskContainerDelta.Kind.DELETED) {
                    change |= UnsubmittedTasksContainer.this.tasks.remove(nbTask);
                    continue;
                }
                if (delta.getKind() != TaskContainerDelta.Kind.ADDED || task.getSynchronizationState() != ITask.SynchronizationState.OUTGOING_NEW) continue;
                change |= UnsubmittedTasksContainer.this.taskList.getUnsubmittedContainer(UnsubmittedTasksContainer.this.repository.getRepositoryUrl()).getChildren().contains(task) && UnsubmittedTasksContainer.this.tasks.add(nbTask);
            }
            if (change) {
                UnsubmittedTasksContainer.this.fireIssuesChanged();
            }
        }
    }
}

