/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.IOException;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormServices;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FormDataLoader
extends MultiFileLoader {
    public static final String FORM_EXTENSION = "form";
    public static final String JAVA_EXTENSION = "java";
    static final long serialVersionUID = 7259146057404524013L;

    public FormDataLoader() {
        super("org.netbeans.modules.form.FormDataObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle(FormDataLoader.class).getString("PROP_FormLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/x-java/Actions/";
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        String ext = fo.getExt();
        if (ext.equals(FORM_EXTENSION)) {
            return FileUtil.findBrother((FileObject)fo, (String)JAVA_EXTENSION);
        }
        FileObject javaFile = this.findJavaPrimaryFile(fo);
        return javaFile != null && FileUtil.findBrother((FileObject)javaFile, (String)FORM_EXTENSION) != null ? javaFile : null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException {
        return new FormDataObject(FileUtil.findBrother((FileObject)primaryFile, (String)FORM_EXTENSION), primaryFile, this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        FormServices services = (FormServices)Lookup.getDefault().lookup(FormServices.class);
        MultiDataObject.Entry entry = services.createPrimaryEntry(obj, primaryFile);
        return entry;
    }

    private FileObject findJavaPrimaryFile(FileObject fo) {
        if (fo.getExt().equals(JAVA_EXTENSION)) {
            return fo;
        }
        return null;
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        assert (FORM_EXTENSION.equals(secondaryFile.getExt()));
        FormEntry formEntry = new FormEntry(obj, secondaryFile);
        ((FormDataObject)obj).formEntry = formEntry;
        return formEntry;
    }

    private static class FormEntry
    extends FileEntry {
        public FormEntry(MultiDataObject mdo, FileObject fo) {
            super(mdo, fo);
        }

        public FileObject createFromTemplate(FileObject folder, String name) throws IOException {
            return FileUtil.copyFile((FileObject)this.getFile(), (FileObject)folder, (String)name);
        }
    }
}

