/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import org.netbeans.modules.form.FormCodeAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.editors2.TreeModelCustomizer;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TreeModelEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor,
FormCodeAwareEditor {
    private static final String NODE_VARIABLE_NAME = "treeNode";
    private FormModel formModel;
    private FormProperty property;
    private static final String XML_TREE_MODEL = "TreeModel";
    private static final String ATTR_CODE = "code";

    @Override
    public String getSourceCode() {
        DefaultTreeModel model = (DefaultTreeModel)this.getValue();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        StringBuilder buf = new StringBuilder();
        String rootVarName = this.generateCode(root, null, 0, buf);
        RADProperty prop = (RADProperty)this.property;
        RADComponent comp = prop.getRADComponent();
        CodeVariable var = comp.getCodeExpression().getVariable();
        String varName = var == null ? null : var.getName();
        String setter = prop.getPropertyDescriptor().getWriteMethod().getName();
        if (varName != null) {
            setter = varName + '.' + setter;
        }
        buf.append(setter).append("(new ");
        buf.append(DefaultTreeModel.class.getName()).append('(').append(rootVarName).append("));\n");
        return buf.toString();
    }

    private String generateCode(DefaultMutableTreeNode node, String parentVarName, int varNameSuffix, StringBuilder buf) {
        String name;
        String varName;
        CodeVariable variable;
        CodeStructure codeStructure = this.formModel.getCodeStructure();
        while ((variable = codeStructure.getVariable(varName = NODE_VARIABLE_NAME + ++varNameSuffix)) != null && !DefaultMutableTreeNode.class.equals((Object)variable.getDeclaredType())) {
        }
        if (variable == null) {
            name = codeStructure.getExternalVariableName(DefaultMutableTreeNode.class, varName, true);
            assert (varName.equals(name));
            buf.append(DefaultMutableTreeNode.class.getName()).append(' ');
        }
        buf.append(varName).append(" = new ");
        buf.append(DefaultMutableTreeNode.class.getName()).append('(').append('\"');
        name = node.getUserObject().toString();
        name = name.replace("\"", "\\\"");
        buf.append(name).append("\");\n");
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            this.generateCode(child, varName, varNameSuffix, buf);
        }
        if (parentVarName != null) {
            buf.append(parentVarName).append(".add(").append(varName).append(");\n");
        }
        return varName;
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        this.formModel = formModel;
        this.property = property;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new TreeModelCustomizer(this);
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rectangle) {
        String msg = NbBundle.getMessage(TreeModelEditor.class, (String)"MSG_TreeModel");
        FontMetrics fm = g.getFontMetrics();
        g.drawString(msg, rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getBundle(TreeModelEditor.class).getString("CTL_TreeModelEditor_DisplayName");
    }

    TreeModel createTreeModel(String txt) {
        StringTokenizer st = new StringTokenizer(txt, "\n");
        ArrayList<Integer> indents = new ArrayList<Integer>();
        ArrayList<String> names = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            String name = line.trim();
            if (name.length() == 0) continue;
            int indent = 0;
            while (line.charAt(indent) == ' ') {
                ++indent;
            }
            indents.add(indent);
            names.add(name);
        }
        DefaultMutableTreeNode root = null;
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(names.size());
        for (int i = 0; i < names.size(); ++i) {
            DefaultMutableTreeNode parent;
            int ind;
            int j;
            int indent = (Integer)indents.get(i);
            String name = (String)names.get(i);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
            nodes.add(node);
            if (i == 0) continue;
            for (j = i - 1; j >= 0 && (ind = ((Integer)indents.get(j)).intValue()) >= indent; --j) {
            }
            if (j >= 0) {
                parent = (DefaultMutableTreeNode)nodes.get(j);
            } else {
                if (root == null) {
                    root = new DefaultMutableTreeNode("root");
                    root.add((MutableTreeNode)nodes.get(0));
                }
                parent = root;
            }
            parent.add(node);
        }
        if (nodes.isEmpty()) {
            root = new DefaultMutableTreeNode("root");
        }
        if (root == null) {
            root = (DefaultMutableTreeNode)nodes.get(0);
        }
        root.setUserObject(new CodeUserObject(root.getUserObject().toString(), txt));
        DefaultTreeModel model = new DefaultTreeModel(root);
        return model;
    }

    String getCodeValue() {
        DefaultMutableTreeNode rootNode;
        Object userObject;
        DefaultTreeModel model;
        Object root;
        Object value = this.getValue();
        if (value instanceof DefaultTreeModel && (root = (model = (DefaultTreeModel)value).getRoot()) instanceof DefaultMutableTreeNode && (userObject = (rootNode = (DefaultMutableTreeNode)root).getUserObject()) instanceof CodeUserObject) {
            CodeUserObject code = (CodeUserObject)userObject;
            return code.code;
        }
        return null;
    }

    @Override
    public void updateFormVersionLevel() {
        this.formModel.raiseVersionLevel(FormModel.FormVersion.NB65, FormModel.FormVersion.NB65);
    }

    public void readFromXML(Node element) {
        Node attr = element.getAttributes().getNamedItem(ATTR_CODE);
        String txt = attr.getNodeValue();
        this.setValue(this.createTreeModel(txt));
    }

    public Node storeToXML(Document doc) {
        String code = this.getCodeValue();
        if (code != null) {
            Element el = doc.createElement(XML_TREE_MODEL);
            el.setAttribute(ATTR_CODE, code);
            return el;
        }
        return null;
    }

    static class CodeUserObject
    implements Serializable {
        String name;
        String code;

        CodeUserObject(String name, String code) {
            this.name = name;
            this.code = code;
        }

        public String toString() {
            return this.name;
        }
    }
}

