/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.multiview;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.multiview.PreviewMultiViewElement;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PreviewMultiViewDesc
implements MultiViewDescription,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PREFERRED_ID = "webservice-wsdlpreview";
    private DataObject dataObject;
    private FileObject fo;
    private String serviceName;
    private String implementationClass;

    public PreviewMultiViewDesc() {
    }

    public PreviewMultiViewDesc(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public PreviewMultiViewDesc(DataObject dataObject, Service service, FileObject fo) {
        this.dataObject = dataObject;
        this.fo = fo;
        if (service != null) {
            this.serviceName = service.getName();
            this.implementationClass = service.getImplementationClass();
        }
    }

    public PreviewMultiViewDesc(DataObject dataObject, Service service) {
        this.dataObject = dataObject;
        if (service != null) {
            this.serviceName = service.getName();
            this.implementationClass = service.getImplementationClass();
        }
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public int getPersistenceType() {
        return 2;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(PreviewMultiViewDesc.class, (String)"LBL_wsdlPreview_name");
    }

    public Image getIcon() {
        if (this.dataObject != null) {
            return this.dataObject.getNodeDelegate().getIcon(1);
        }
        Image fault = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/design/view/resources/fault.png", (boolean)false);
        return fault;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PreviewMultiViewDesc.class);
    }

    public MultiViewElement createElement() {
        if (this.implementationClass == null) {
            if (this.dataObject == null) {
                return new PreviewMultiViewElement();
            }
            return new PreviewMultiViewElement((DataEditorSupport)this.dataObject.getLookup().lookup(DataEditorSupport.class));
        }
        DataObject wsdl = this.createPreviewForJava();
        if (wsdl == null || wsdl.getLookup().lookup(DataEditorSupport.class) == null) {
            return new PreviewMultiViewElement();
        }
        DataEditorSupport des = (DataEditorSupport)wsdl.getLookup().lookup(DataEditorSupport.class);
        return new PreviewMultiViewElement(des);
    }

    public DataObject createPreviewForJava() {
        DataObject dataObj = null;
        if (this.dataObject != null) {
            FileObject primaryFile = this.dataObject.getPrimaryFile();
            String tempdir = System.getProperty("java.io.tmpdir");
            FileObject wsdlFile = null;
            final Properties prop = new Properties();
            prop.setProperty("build.generated.dir", tempdir);
            Project project = FileOwnerQuery.getOwner((FileObject)primaryFile);
            JavaSource targetSource = JavaSource.forFileObject((FileObject)this.getFileObject(project));
            FindMethodTask fmt = new FindMethodTask();
            try {
                targetSource.runUserActionTask((Task)fmt, true);
                if (fmt.found) {
                    final FileObject jaxwsImplFo = project.getProjectDirectory().getFileObject("build.xml");
                    RequestProcessor.getDefault().post(new Runnable(){
                        final /* synthetic */ PreviewMultiViewDesc this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            try {
                                ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)jaxwsImplFo, (String[])new String[]{"wsgen-" + this.this$0.serviceName}, (Properties)prop);
                                wsimportTask.waitFinished();
                            }
                            catch (IllegalArgumentException ex) {
                                ErrorManager.getDefault().notify((Throwable)ex);
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify((Throwable)ex);
                            }
                        }
                    });
                    File temp = new File(tempdir);
                    FileUtil.refreshFor((File[])new File[]{temp});
                    String constPart = "wsgen/service/resources/";
                    String suffix = "Service";
                    String tempTestDestpath = tempdir + constPart + this.serviceName + suffix + ".wsdl";
                    File wsdl = new File(tempTestDestpath);
                    wsdlFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)wsdl));
                }
                if (wsdlFile != null) {
                    try {
                        dataObj = DataObject.find(wsdlFile);
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return dataObj;
    }

    public FileObject getFileObject(Project prj) {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)prj).getSourceGroups("java");
        String implClassResource = this.implementationClass.replace('.', '/') + ".java";
        for (SourceGroup srcGroup : srcGroups) {
            FileObject implClassFo = srcGroup.getRootFolder().getFileObject(implClassResource);
            if (implClassFo == null) continue;
            return implClassFo;
        }
        return null;
    }

    class FindMethodTask
    implements CancellableTask<CompilationController> {
        public boolean found = false;

        FindMethodTask() {
        }

        public void cancel() {
        }

        public void run(CompilationController controller) throws Exception {
            TypeElement typeElement = controller.getElements().getTypeElement(PreviewMultiViewDesc.this.implementationClass);
            if (typeElement != null) {
                for (Element element : typeElement.getEnclosedElements()) {
                    if (element.getKind() != ElementKind.METHOD) continue;
                    this.found = true;
                }
            }
        }
    }
}

