/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import org.netbeans.modules.lsp.client.Bundle;
import org.netbeans.modules.lsp.client.ConnectToLanguageServerParameters;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ConnectToLanguageServer
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        ConnectToLanguageServerParameters params = new ConnectToLanguageServerParameters();
        DialogDescriptor dd = new DialogDescriptor((Object)params, "Connect to Language Server", true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            int port;
            params.confirm();
            FileObject root = FileUtil.toFileObject((File)new File(params.getRoot()));
            if (root == null) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_CanFindRoot(), 0));
                return;
            }
            try {
                port = Integer.parseInt(params.getPort());
            }
            catch (NumberFormatException ex) {
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_InvalidPort(), 0));
                return;
            }
            LSPBindings.addBindings(root, port, params.getExtensions().split(","));
        }
    }
}

