/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.groovy.support.wizard.JUnit;
import org.netbeans.modules.groovy.support.wizard.ProjectTypeStrategy;
import org.netbeans.modules.groovy.support.wizard.impl.Bundle;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class AntProjectTypeStrategy
extends ProjectTypeStrategy {
    private static final String JUNIT4_LIB = "junit_4";
    private static final String JUNIT3_LIB = "junit";
    private static final String JUNIT3_SPECIFIC = "junit/awtui/TestRunner.class";
    private static final String JUNIT4_SPECIFIC = "org/junit/Test.class";

    public AntProjectTypeStrategy(Project project) {
        super(project);
    }

    @Override
    public void addJUnitLibrary(JUnit jUnit) {
        this.storeProjectSettingsJUnitVer(jUnit);
    }

    @Override
    public boolean existsGroovyTestFolder(List<SourceGroup> groups) {
        return this.existsFolder(groups, "test");
    }

    @Override
    public boolean existsGroovySourceFolder(List<SourceGroup> groups) {
        return this.existsFolder(groups, "src");
    }

    private boolean existsFolder(List<SourceGroup> groups, String folderName) {
        for (SourceGroup group : groups) {
            String groupPath = group.getRootFolder().getPath();
            if (!groupPath.endsWith("/" + folderName) && !groupPath.contains("/" + folderName + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createGroovyTestFolder() {
        this.createFolder(this.project.getProjectDirectory(), "test");
    }

    @Override
    public void createGroovySourceFolder() {
        this.createFolder(this.project.getProjectDirectory(), "src");
    }

    @Override
    public List<SourceGroup> moveTestFolderAsFirst(List<SourceGroup> groups) {
        return this.moveAsFirst(groups, "/test").subList(0, 1);
    }

    @Override
    public List<SourceGroup> moveSourceFolderAsFirst(List<SourceGroup> groups) {
        return this.moveAsFirst(groups, "/src");
    }

    @Override
    public JUnit findJUnitVersion() {
        boolean hasJUnit4;
        boolean hasJUnit3;
        ClassPath classPath = this.getTestClassPath(this.project);
        if (classPath != null) {
            hasJUnit3 = classPath.findResource(JUNIT3_SPECIFIC) != null;
            hasJUnit4 = classPath.findResource(JUNIT4_SPECIFIC) != null;
        } else {
            hasJUnit3 = false;
            hasJUnit4 = false;
        }
        if (hasJUnit4) {
            return JUnit.JUNIT4;
        }
        if (hasJUnit3) {
            return JUnit.JUNIT3;
        }
        return JUnit.NOT_DECLARED;
    }

    private ClassPath getTestClassPath(Project project) {
        ClassPathProvider cpProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (cpProvider == null) {
            return null;
        }
        for (FileObject testRoot : this.getTestFolders(project)) {
            ClassPath testClassPath = cpProvider.findClassPath(testRoot, "classpath/compile");
            if (testClassPath == null) continue;
            return testClassPath;
        }
        return null;
    }

    private List<FileObject> getTestFolders(Project project) {
        FileObject[] children;
        ArrayList<FileObject> testFolders = new ArrayList<FileObject>();
        for (FileObject child : children = project.getProjectDirectory().getChildren()) {
            if (!child.getNameExt().startsWith("test")) continue;
            testFolders.add(child);
        }
        return testFolders;
    }

    private boolean storeProjectSettingsJUnitVer(JUnit jUnit) {
        Library[] libraries;
        boolean hasJUnit4;
        boolean hasJUnit3;
        ClassPath classPath;
        String version = "";
        if (jUnit == JUnit.JUNIT3) {
            version = JUNIT3_LIB;
        } else if (jUnit == JUnit.JUNIT4) {
            version = JUNIT4_LIB;
        }
        if (LibraryManager.getDefault().getLibrary(version) == null) {
            for (BrokenReferencesSupport.LibraryDefiner definer : Lookup.getDefault().lookupAll(BrokenReferencesSupport.LibraryDefiner.class)) {
                Callable download = definer.missingLibrary(version);
                if (download == null) continue;
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)Bundle.junitlib_confirm_text(), Bundle.junitlib_confirm_title());
                JButton accept = new JButton(Bundle.junitlib_confirm_accept());
                accept.setDefaultCapable(true);
                nd.setOptions(new Object[]{accept, NotifyDescriptor.CANCEL_OPTION});
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == accept) {
                    try {
                        download.call();
                        break;
                    }
                    catch (Exception x) {
                        return false;
                    }
                }
                return false;
            }
        }
        if ((classPath = this.getTestClassPath(this.project)) != null) {
            hasJUnit3 = classPath.findResource(JUNIT3_SPECIFIC) != null;
            hasJUnit4 = classPath.findResource(JUNIT4_SPECIFIC) != null;
        } else {
            hasJUnit3 = false;
            hasJUnit4 = false;
        }
        Pattern pattern = Pattern.compile("^junit(?:_|\\W)+([34])(?:\\b|_).*");
        JUnitLibraryComparator libraryComparator = null;
        Library libraryToAdd = null;
        ArrayList<Library> librariesToRemove = null;
        for (Library library : libraries = LibraryManager.getDefault().getLibraries()) {
            String verNumToRemove;
            String name = library.getName().toLowerCase();
            if (!name.startsWith(JUNIT3_LIB)) continue;
            boolean add = false;
            boolean remove = false;
            String verNumToAdd = jUnit == JUnit.JUNIT3 && !hasJUnit3 ? "3" : (jUnit == JUnit.JUNIT4 && !hasJUnit4 ? "4" : null);
            String string = verNumToRemove = jUnit == JUnit.JUNIT3 ? "4" : "3";
            if (name.equals(JUNIT3_LIB)) {
                add = verNumToAdd == "3";
                remove = verNumToRemove == "3";
            } else {
                Matcher matcher = pattern.matcher(name);
                if (matcher.matches()) {
                    String verNum = matcher.group(1);
                    add = verNum.equals(verNumToAdd);
                    remove = verNum.equals(verNumToRemove);
                }
            }
            if (add) {
                if (libraryToAdd == null) {
                    libraryToAdd = library;
                } else {
                    if (libraryComparator == null) {
                        libraryComparator = new JUnitLibraryComparator();
                    }
                    if (libraryComparator.compare(libraryToAdd, library) > 0) {
                        libraryToAdd = library;
                    }
                }
            }
            if (!remove) continue;
            if (librariesToRemove == null) {
                librariesToRemove = new ArrayList<Library>(2);
            }
            librariesToRemove.add(library);
        }
        if (libraryToAdd == null && librariesToRemove == null) {
            return true;
        }
        final List<FileObject> projectArtifacts = this.getProjectTestArtifacts(this.project);
        if (projectArtifacts.isEmpty()) {
            return true;
        }
        final Library[] libsToAdd = libraryToAdd != null ? new Library[]{libraryToAdd} : null;
        final Library[] libsToRemove = librariesToRemove != null ? librariesToRemove.toArray(new Library[0]) : null;
        assert (libsToAdd != null || libsToRemove != null);
        class LibrarySetModifier
        implements Runnable {
            final /* synthetic */ AntProjectTypeStrategy this$0;

            LibrarySetModifier() {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                boolean modified = false;
                try {
                    if (libsToAdd != null) {
                        for (FileObject prjArtifact : projectArtifacts) {
                            modified |= ProjectClassPathModifier.addLibraries((Library[])libsToAdd, (FileObject)prjArtifact, (String)"classpath/compile");
                        }
                    }
                    if (libsToRemove != null) {
                        for (FileObject prjArtifact : projectArtifacts) {
                            modified |= ProjectClassPathModifier.removeLibraries((Library[])libsToRemove, (FileObject)prjArtifact, (String)"classpath/compile");
                        }
                    }
                }
                catch (UnsupportedOperationException ex) {
                    String prjName = ProjectUtils.getInformation((Project)this.this$0.project).getDisplayName();
                    ErrorManager.getDefault().log(16, "Project " + prjName + ": Could not modify set of JUnit libraries - operation not supported by the project.");
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(65536, (Throwable)ex);
                }
                if (modified) {
                    try {
                        ProjectManager.getDefault().saveProject(this.this$0.project);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(65536, (Throwable)ex);
                    }
                }
            }
        }
        ProjectManager.mutex().writeAccess((Runnable)new LibrarySetModifier());
        return true;
    }

    private List<FileObject> getProjectTestArtifacts(Project project) {
        ClassPathProvider cpProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        List<FileObject> testFolders = this.getTestFolders(project);
        List<FileObject> result = null;
        for (FileObject testRoot : testFolders) {
            ClassPath testClassPath = cpProvider.findClassPath(testRoot, "classpath/compile");
            if (testClassPath == null) continue;
            if (result == null) {
                if (testFolders.size() == 1) {
                    return Collections.singletonList(testRoot);
                }
                result = new ArrayList<FileObject>(3);
            }
            result.add(testRoot);
        }
        return result != null ? result : Collections.emptyList();
    }

    private static class JUnitLibraryComparator
    implements Comparator<Library>,
    Serializable {
        private JUnitLibraryComparator() {
        }

        @Override
        public int compare(Library l1, Library l2) {
            String name2;
            String name1 = l1.getName().toLowerCase();
            if (name1.equals(name2 = l2.getName().toLowerCase())) {
                return 0;
            }
            if (name1.equals(AntProjectTypeStrategy.JUNIT3_LIB)) {
                return -1;
            }
            if (name2.equals(AntProjectTypeStrategy.JUNIT3_LIB)) {
                return 1;
            }
            String[] parts1 = name1.substring(5).split("_|\\W");
            String[] parts2 = name2.substring(5).split("_|\\W");
            int min = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < min; ++i) {
                int partCmp = parts1[i].compareTo(parts2[i]);
                if (partCmp == 0) continue;
                return partCmp;
            }
            return parts2.length - parts1.length;
        }
    }
}

