/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.libraries;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NpmExecutable;
import org.netbeans.modules.javascript.nodejs.ui.libraries.Library;
import org.openide.util.RequestProcessor;

public class LibraryProvider {
    private static final Logger LOGGER = Logger.getLogger(LibraryProvider.class.getName());
    private static final Map<Project, LibraryProvider> providers = Collections.synchronizedMap(new WeakHashMap());
    private static final RequestProcessor RP = new RequestProcessor(LibraryProvider.class.getName(), 3);
    private final Project project;
    private final Map<String, WeakReference<Library[]>> searchCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, WeakReference<Library>> detailCache = Collections.synchronizedMap(new HashMap());
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private LibraryProvider(Project project) {
        this.project = project;
    }

    public static synchronized LibraryProvider forProject(Project project) {
        LibraryProvider provider = providers.get(project);
        if (provider == null) {
            provider = new LibraryProvider(project);
            providers.put(project, provider);
        }
        return provider;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Library[] findLibraries(String searchTerm) {
        WeakReference<Library[]> reference = this.searchCache.get(searchTerm);
        Library[] result = null;
        if (reference != null) {
            result = (Library[])reference.get();
        }
        if (result == null) {
            SearchTask task = new SearchTask(searchTerm);
            RP.post((Runnable)task);
        }
        return result;
    }

    public Library libraryDetails(String libraryName, boolean cachedOnly) {
        WeakReference<Library> reference = this.detailCache.get(libraryName);
        Library result = null;
        if (reference != null) {
            result = (Library)reference.get();
        }
        if (result == null && !cachedOnly) {
            JSONObject details;
            assert (!EventQueue.isDispatchThread());
            NpmExecutable executable = NpmExecutable.getDefault(this.project, false);
            if (executable != null && (details = executable.view(libraryName)) != null) {
                result = this.parseLibraryDetails(details);
                reference = new WeakReference<Library>(result);
                this.detailCache.put(libraryName, reference);
            }
        }
        return result;
    }

    public Map<String, String> installedLibraries() {
        JSONObject json;
        HashMap<String, String> result = null;
        NpmExecutable executable = NpmExecutable.getDefault(this.project, false);
        if (executable != null && (json = executable.list(0)) != null) {
            result = new HashMap<String, String>();
            JSONObject dependencies = (JSONObject)json.get((Object)"dependencies");
            if (dependencies != null) {
                Set entrySet = dependencies.entrySet();
                for (Map.Entry entry : entrySet) {
                    JSONObject libraryInfo;
                    String versionName;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(value instanceof JSONObject) || (versionName = (String)(libraryInfo = (JSONObject)value).get((Object)"version")) == null) continue;
                    String libraryName = key.toString();
                    result.put(libraryName, versionName);
                }
            }
        }
        return result;
    }

    private Library parseLibraryDetails(JSONObject viewInfo) {
        Library.Version[] versions;
        String name = (String)viewInfo.get((Object)"name");
        Library library = new Library(name);
        String latestVersionName = (String)viewInfo.get((Object)"version");
        Library.Version latestVersion = null;
        Object versionsObject = viewInfo.get((Object)"versions");
        if (versionsObject instanceof JSONArray) {
            JSONArray versionArray = (JSONArray)viewInfo.get((Object)"versions");
            versions = new Library.Version[versionArray.size()];
            for (int i = 0; i < versionArray.size(); ++i) {
                String versionName = (String)versionArray.get(i);
                Library.Version version = new Library.Version(library, versionName);
                if (versionName.equals(latestVersionName)) {
                    latestVersion = version;
                }
                versions[i] = version;
            }
        } else {
            latestVersion = new Library.Version(library, versionsObject.toString());
            versions = new Library.Version[]{latestVersion};
        }
        library.setVersions(versions);
        library.setLatestVersion(latestVersion);
        return library;
    }

    void updateCache(String searchTerm, Library[] libraries) {
        if (libraries != null) {
            WeakReference<Library[]> reference = new WeakReference<Library[]>(libraries);
            this.searchCache.put(searchTerm, reference);
        }
        this.propertyChangeSupport.firePropertyChange(searchTerm, null, libraries);
    }

    private class SearchTask
    implements Runnable {
        private final String searchTerm;

        SearchTask(String searchTerm) {
            this.searchTerm = searchTerm;
        }

        @Override
        public void run() {
            NpmExecutable executable = NpmExecutable.getDefault(LibraryProvider.this.project, false);
            if (executable != null) {
                String result = executable.search(this.searchTerm);
                Library[] libraries = result == null ? null : this.parseSearchResult(result);
                LibraryProvider.this.updateCache(this.searchTerm, libraries);
            }
        }

        @CheckForNull
        private Library[] parseSearchResult(String searchResult) {
            String[] lines = searchResult.split("\n");
            ArrayList<Library> libraries = new ArrayList<Library>(lines.length);
            for (String line : lines) {
                String[] columns = line.split("\t");
                if (columns.length < 5) continue;
                Library library = new Library(columns[0].trim());
                library.setDescription(columns[1].trim());
                Library.Version latestVersion = new Library.Version(library, columns[4].trim());
                library.setLatestVersion(latestVersion);
                if (columns.length > 5) {
                    library.setKeywords(columns[5].split(" "));
                }
                libraries.add(library);
            }
            return libraries.toArray(new Library[0]);
        }
    }
}

