/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.UnicodeReader;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;
import java.util.Arrays;

public class JavadocTokenizer
extends JavaTokenizer {
    final ScannerFactory fac;

    protected JavadocTokenizer(ScannerFactory fac, CharBuffer cb) {
        super(fac, cb);
        this.fac = fac;
    }

    protected JavadocTokenizer(ScannerFactory fac, char[] array, int length) {
        super(fac, array, length);
        this.fac = fac;
    }

    @Override
    protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
        return new JavadocComment(style, this, pos, endPos);
    }

    @Override
    public Position.LineMap getLineMap() {
        char[] buf = this.getRawCharacters();
        return Position.makeLineMap(buf, buf.length, true);
    }

    protected static class JavadocComment
    extends JavaTokenizer.BasicComment {
        private String docComment = null;
        private StringBuilder sb;
        private boolean firstLine = true;
        OffsetMap offsetMap = new OffsetMap();

        JavadocComment(Tokens.Comment.CommentStyle cs, UnicodeReader reader, int pos, int endPos) {
            super(cs, reader, pos, endPos);
            this.sb = new StringBuilder();
        }

        @Override
        protected void putLine(UnicodeReader line) {
            if (this.firstLine) {
                this.firstLine = false;
            } else {
                this.sb.append('\n');
                this.offsetMap.add(this.sb.length(), line.position());
            }
            while (line.isAvailable()) {
                this.offsetMap.add(this.sb.length(), line.position());
                if (line.isSurrogate()) {
                    this.sb.appendCodePoint(line.getCodepoint());
                } else {
                    this.sb.append(line.get());
                }
                line.next();
            }
        }

        @Override
        public String getText() {
            if (!this.scanned) {
                this.scanDocComment();
            }
            return this.docComment;
        }

        @Override
        public int getSourcePos(int pos) {
            if (pos == -1) {
                return -1;
            }
            if (pos < 0 || pos > this.docComment.length()) {
                throw new StringIndexOutOfBoundsException(String.valueOf(pos));
            }
            return this.offsetMap.getSourcePos(pos);
        }

        @Override
        protected void scanDocComment() {
            try {
                super.scanDocComment();
            }
            finally {
                this.docComment = this.sb.toString();
                this.sb = null;
                this.offsetMap.trim();
            }
        }
    }

    static class OffsetMap {
        private static final int SB_OFFSET = 0;
        private static final int POS_OFFSET = 1;
        private static final int NOFFSETS = 2;
        private int[] map = new int[128];
        private int size = 0;

        OffsetMap() {
        }

        boolean shouldAdd(int sbOffset, int posOffset) {
            return sbOffset - this.lastSBOffset() != posOffset - this.lastPosOffset();
        }

        void add(int sbOffset, int posOffset) {
            if (this.size == 0 || this.shouldAdd(sbOffset, posOffset)) {
                this.ensure(2);
                this.map[this.size + 0] = sbOffset;
                this.map[this.size + 1] = posOffset;
                this.size += 2;
            }
        }

        private int lastSBOffset() {
            return this.size == 0 ? 0 : this.map[this.size - 2 + 0];
        }

        private int lastPosOffset() {
            return this.size == 0 ? 0 : this.map[this.size - 2 + 1];
        }

        private void ensure(int need) {
            int grow;
            need += this.size;
            for (grow = this.map.length; need > grow; grow <<= 1) {
            }
            if (grow < this.map.length) {
                throw new IndexOutOfBoundsException();
            }
            if (grow != this.map.length) {
                this.map = Arrays.copyOf(this.map, grow);
            }
        }

        void trim() {
            this.map = Arrays.copyOf(this.map, this.size);
        }

        int getSourcePos(int pos) {
            if (this.size == 0) {
                return -1;
            }
            int start = 0;
            int end = this.size / 2;
            while (start < end - 1) {
                int index = (start + end) / 2;
                int indexScaled = index * 2;
                if (this.map[indexScaled + 0] < pos) {
                    start = index;
                    continue;
                }
                if (this.map[indexScaled + 0] == pos) {
                    return this.map[indexScaled + 1];
                }
                end = index;
            }
            int startScaled = start * 2;
            return this.map[startScaled + 1] + (pos - this.map[startScaled + 0]);
        }
    }
}

