/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.openide.text.AttributedCharacters;

public final class Editor
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (!(object instanceof List)) {
            return;
        }
        List list = (List)object;
        if (list.size() != 3) {
            return;
        }
        Object param0 = list.get(0);
        if (!(param0 instanceof BaseDocument)) {
            return;
        }
        BaseDocument document = (BaseDocument)param0;
        Object param1 = list.get(1);
        if (!(param1 instanceof Integer)) {
            return;
        }
        int start = (Integer)param1;
        Object param2 = list.get(2);
        if (!(param2 instanceof Integer)) {
            return;
        }
        int end = (Integer)param2;
        PrintContainer container = new PrintContainer();
        document.print((org.netbeans.editor.PrintContainer)container, false, true, start, end);
        list.add(container.getIterators());
    }

    private static final class PrintContainer
    implements org.netbeans.editor.PrintContainer {
        private AttributedCharacters myCharacters = new AttributedCharacters();
        private List<AttributedCharacters> myCharactersList = new ArrayList<AttributedCharacters>();

        PrintContainer() {
        }

        public void add(char[] chars, Font font, Color foreColor, Color backColor) {
            this.myCharacters.append(chars, font, foreColor);
        }

        public void eol() {
            this.myCharactersList.add(this.myCharacters);
            this.myCharacters = new AttributedCharacters();
        }

        public boolean initEmptyLines() {
            return false;
        }

        AttributedCharacterIterator[] getIterators() {
            AttributedCharacterIterator[] iterators = new AttributedCharacterIterator[this.myCharactersList.size()];
            for (int i = 0; i < this.myCharactersList.size(); ++i) {
                iterators[i] = this.myCharactersList.get(i).iterator();
            }
            return iterators;
        }

        private String getString(Color color) {
            return "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
        }

        private String getString(Font font) {
            String style = "";
            if (font.isBold()) {
                style = style + "bold";
            }
            style = font.isItalic() ? style + " italic" : style + " plain";
            return "[" + font.getName() + ", " + style + ", " + font.getSize() + "]";
        }

        private void out() {
            System.out.println();
        }

        private void out(Object object) {
            System.out.println("*** " + object);
        }
    }
}

