/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.debuggingview;

import javax.swing.Action;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.Utils;
import org.netbeans.modules.cpplite.debugger.debuggingview.Bundle;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public class DebuggingActionsProvider
implements NodeActionsProvider {
    private final CPPLiteDebugger debugger;
    private final RequestProcessor requestProcessor = new RequestProcessor("Debugging View Actions", 1);
    private final Action MAKE_CURRENT_ACTION;
    private final Action SUSPEND_ACTION;
    private final Action RESUME_ACTION;
    private final Action GO_TO_SOURCE_ACTION;

    public DebuggingActionsProvider(ContextProvider lookupProvider) {
        this.debugger = (CPPLiteDebugger)lookupProvider.lookupFirst(null, CPPLiteDebugger.class);
        this.MAKE_CURRENT_ACTION = this.createMAKE_CURRENT_ACTION(this.requestProcessor);
        this.SUSPEND_ACTION = this.createSUSPEND_ACTION(this.requestProcessor);
        this.RESUME_ACTION = this.createRESUME_ACTION(this.requestProcessor);
        this.GO_TO_SOURCE_ACTION = DebuggingActionsProvider.createGO_TO_SOURCE_ACTION(this.requestProcessor);
    }

    private Action createMAKE_CURRENT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_ThreadAction_MakeCurrent_Label(), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof CPPThread) {
                    return DebuggingActionsProvider.this.debugger.getCurrentThread() != node;
                }
                if (node instanceof CPPFrame) {
                    CPPFrame frame = (CPPFrame)node;
                    return !frame.equals(DebuggingActionsProvider.this.debugger.getCurrentFrame());
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                if (nodes.length == 0) {
                    return;
                }
                if (nodes[0] instanceof CPPThread) {
                    CPPThread thread = (CPPThread)nodes[0];
                    thread.makeCurrent();
                    DebuggingActionsProvider.goToSource(thread);
                }
                if (nodes[0] instanceof CPPFrame) {
                    CPPFrame frame = (CPPFrame)nodes[0];
                    frame.makeCurrent();
                    DebuggingActionsProvider.goToSource(frame);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createGO_TO_SOURCE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_ThreadAction_GoToSource_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                if (!(node instanceof CPPFrame)) {
                    return false;
                }
                return DebuggingActionsProvider.isGoToSourceSupported((CPPFrame)node);
            }

            public void perform(final Object[] nodes) {
                requestProcessor.post(new Runnable(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        DebuggingActionsProvider.goToSource((CPPFrame)nodes[0]);
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createSUSPEND_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_ThreadAction_Suspend_Label(), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof CPPThread) {
                    return !((CPPThread)node).isSuspended();
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                for (Object node : nodes) {
                    if (!(node instanceof CPPThread)) continue;
                    ((CPPThread)node).suspend();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    private Action createRESUME_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_ThreadAction_Resume_Label(), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof CPPThread) {
                    return ((CPPThread)node).isSuspended();
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                for (Object node : nodes) {
                    if (!(node instanceof CPPThread)) continue;
                    ((CPPThread)node).resume();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof CPPThread) {
            CPPThread thread = (CPPThread)node;
            boolean suspended = thread.isSuspended();
            return new Action[]{this.MAKE_CURRENT_ACTION, suspended ? this.RESUME_ACTION : this.SUSPEND_ACTION};
        }
        if (node instanceof CPPFrame) {
            return new Action[]{this.MAKE_CURRENT_ACTION, this.GO_TO_SOURCE_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(final Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof CPPThread || node instanceof CPPFrame) {
            this.requestProcessor.post(new Runnable(){
                final /* synthetic */ DebuggingActionsProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (node instanceof CPPThread) {
                        ((CPPThread)node).makeCurrent();
                    } else if (node instanceof CPPFrame) {
                        CPPFrame frame = (CPPFrame)node;
                        frame.makeCurrent();
                        DebuggingActionsProvider.goToSource(frame);
                    }
                }
            });
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static boolean isGoToSourceSupported(CPPFrame frame) {
        Line currentLine = frame.location();
        return currentLine != null;
    }

    private static void goToSource(CPPFrame frame) {
        Line currentLine = frame.location();
        if (currentLine != null) {
            Utils.showLine(new Line[]{currentLine});
        }
    }

    private static void goToSource(CPPThread thread) {
        CPPFrame topFrame = thread.getTopFrame();
        if (topFrame != null) {
            DebuggingActionsProvider.goToSource(topFrame);
        }
    }

    private static abstract class LazyActionPerformer
    implements Models.ActionPerformer {
        private RequestProcessor rp;

        public LazyActionPerformer(RequestProcessor rp) {
            this.rp = rp;
        }

        public abstract boolean isEnabled(Object var1);

        public final void perform(final Object[] nodes) {
            this.rp.post(new Runnable(){
                final /* synthetic */ LazyActionPerformer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.run(nodes);
                }
            });
        }

        public abstract void run(Object[] var1);
    }
}

