/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.java.file.launcher.queries.MultiSourceRootProvider;
import org.netbeans.modules.java.file.launcher.spi.SingleFileOptionsQueryImplementation;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class SingleSourceFileUtil {
    public static final Logger LOG = Logger.getLogger(SingleSourceFileUtil.class.getPackage().getName());
    public static final String GLOBAL_VM_OPTIONS = "java_file_launcher_global_vm_options";
    public static final String GLOBAL_STOP_AND_RUN_OPTION = "java_file_launcher_global_stop_and_run_option";
    public static final String FILE_ARGUMENTS = "single_file_run_arguments";
    public static final String FILE_JDK = "single_file_run_jdk";
    public static final String FILE_VM_OPTIONS = "single_file_vm_options";
    public static final String FILE_REGISTER_ROOT = "register_root";
    private static final LineParser PARSER = new LineParser();

    public static int findJavaVersion() throws NumberFormatException {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        int version = Integer.parseInt(javaVersion);
        return version;
    }

    public static FileObject getJavaFileWithoutProjectFromLookup(Lookup lookup) {
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            if (!SingleSourceFileUtil.isSingleSourceFile(fObj)) continue;
            return fObj;
        }
        for (FileObject fObj : lookup.lookupAll(FileObject.class)) {
            if (!SingleSourceFileUtil.isSingleSourceFile(fObj)) continue;
            return fObj;
        }
        return null;
    }

    public static boolean isSingleSourceFile(FileObject fObj) {
        return SingleSourceFileUtil.isSupportedFile(fObj) && fObj.getExt().equalsIgnoreCase("java");
    }

    public static boolean isSupportedFile(FileObject file) {
        if (file == null) {
            return false;
        }
        try {
            FileObject dir = file.getParent();
            File dirFile = dir != null ? FileUtil.toFile((FileObject)dir) : null;
            return !MultiSourceRootProvider.DISABLE_MULTI_SOURCE_ROOT && FileOwnerQuery.getOwner((FileObject)file) == null && !file.getFileSystem().isReadOnly() && (dirFile == null || !dirFile.getName().startsWith("vcs-") || !dirFile.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir")));
        }
        catch (FileStateInvalidException ex) {
            return false;
        }
    }

    public static Process compileJavaSource(FileObject fileObject, JavaPlatform jdk) {
        String globalVmOptions;
        String vmOptions;
        FileObject javac = jdk.findTool("javac");
        File javacFile = FileUtil.toFile((FileObject)javac);
        String javacPath = javacFile.getAbsolutePath();
        ArrayList<String> compileCommandList = new ArrayList<String>();
        Object compilerVmOptionsObj = fileObject.getAttribute(FILE_VM_OPTIONS);
        compileCommandList.add(javacPath);
        compileCommandList.add("-g");
        String string = vmOptions = compilerVmOptionsObj != null ? ((String)compilerVmOptionsObj).trim() : "";
        if (!vmOptions.isEmpty()) {
            compileCommandList.addAll(Arrays.asList(vmOptions.split(" ")));
        }
        if (!(globalVmOptions = NbPreferences.forModule(JavaPlatformManager.class).get(GLOBAL_VM_OPTIONS, "").trim()).isEmpty()) {
            compileCommandList.addAll(Arrays.asList(globalVmOptions.split(" ")));
        }
        compileCommandList.add(fileObject.getPath());
        ProcessBuilder compileProcessBuilder = new ProcessBuilder(compileCommandList);
        compileProcessBuilder.directory(new File(fileObject.getParent().getPath()));
        compileProcessBuilder.redirectErrorStream(true);
        compileProcessBuilder.redirectOutput();
        try {
            return compileProcessBuilder.start();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not get InputStream of Compile Process");
            return null;
        }
    }

    public static boolean hasClassSibling(FileObject fo) {
        return fo.getParent().getFileObject(fo.getName(), "class") != null;
    }

    public static ParsedFileOptions getOptionsFor(FileObject file) {
        if (MultiSourceRootProvider.DISABLE_MULTI_SOURCE_ROOT) {
            return null;
        }
        for (SingleFileOptionsQueryImplementation i : Lookup.getDefault().lookupAll(SingleFileOptionsQueryImplementation.class)) {
            SingleFileOptionsQueryImplementation.Result r = i.optionsFor(file);
            if (r == null) continue;
            return new ParsedFileOptions(r);
        }
        return null;
    }

    public static List<String> parseLine(String line, URI workingDirectory) {
        return PARSER.doParse(line, workingDirectory);
    }

    public static boolean isTrue(Object value) {
        Boolean b;
        return value instanceof Boolean && (b = (Boolean)value) != false;
    }

    public static final class ParsedFileOptions
    extends CompilerOptionsQueryImplementation.Result
    implements ChangeListener {
        private final ChangeSupport cs;
        private final SingleFileOptionsQueryImplementation.Result delegate;
        private final AtomicInteger updateCount = new AtomicInteger(0);
        private List<? extends String> arguments;

        private ParsedFileOptions(SingleFileOptionsQueryImplementation.Result delegate) {
            this.cs = new ChangeSupport((Object)this);
            this.delegate = delegate;
            this.delegate.addChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends String> getArguments() {
            int update;
            ParsedFileOptions parsedFileOptions = this;
            synchronized (parsedFileOptions) {
                if (this.arguments != null) {
                    return this.arguments;
                }
                update = this.updateCount.get();
            }
            while (true) {
                List newArguments = Collections.unmodifiableList(this.parseLine(this.delegate.getOptions(), this.delegate.getWorkDirectory()));
                ParsedFileOptions parsedFileOptions2 = this;
                synchronized (parsedFileOptions2) {
                    if (update == this.updateCount.get()) {
                        this.arguments = newArguments;
                        return newArguments;
                    }
                    update = this.updateCount.get();
                }
            }
        }

        public URI getWorkDirectory() {
            return this.delegate.getWorkDirectory();
        }

        public boolean registerRoot() {
            return this.delegate.registerRoot();
        }

        public void addChangeListener(ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent ce) {
            ParsedFileOptions parsedFileOptions = this;
            synchronized (parsedFileOptions) {
                this.arguments = null;
                this.updateCount.incrementAndGet();
            }
            this.cs.fireChange();
        }
    }

    private static class LineParser
    extends CompilerOptionsQueryImplementation.Result {
        private LineParser() {
        }

        public List<String> doParse(String line, URI workingDirectory) {
            return this.parseLine(line, workingDirectory);
        }

        public List<? extends String> getArguments() {
            return null;
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }
}

