/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api.beans.model;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelFactory;
import org.netbeans.modules.spring.api.beans.model.ModelUnit;
import org.netbeans.modules.spring.api.beans.model.SpringModel;
import org.netbeans.modules.spring.beans.model.impl.SpringModelImplementation;

public final class SpringModelFactory {
    private static final Logger LOGGER = Logger.getLogger(SpringModelFactory.class.getName());
    protected static HashMap<ModelUnit, WeakReference<MetadataModel<SpringModel>>> MODELS = new HashMap();

    private SpringModelFactory() {
    }

    public static synchronized MetadataModel<SpringModel> getMetaModel(ModelUnit unit) {
        WeakReference<MetadataModel<SpringModel>> reference = MODELS.get(unit);
        MetadataModel<SpringModel> metadataModel = null;
        if (reference != null) {
            metadataModel = (MetadataModel<SpringModel>)reference.get();
        }
        if (metadataModel == null) {
            LOGGER.log(Level.FINE, "Metadata model not found in cache for model unit: {0}, reference: {1}", new Object[]{unit, reference});
            metadataModel = SpringModelFactory.createMetaModel(unit);
            if (reference == null) {
                LOGGER.log(Level.FINE, "No reference found, creating new one.");
                reference = new WeakReference<MetadataModel<SpringModel>>(metadataModel);
            }
            MODELS.put(unit, reference);
        }
        return metadataModel;
    }

    public static MetadataModel<SpringModel> createMetaModel(ModelUnit unit) {
        LOGGER.log(Level.FINE, "Creating metadata model for model unit: {0}", unit);
        return MetadataModelFactory.createMetadataModel(SpringModelImplementation.createMetaModel(unit));
    }
}

