/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.ui.customizer;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.spring.beans.ui.customizer.ConfigFilesUIs;
import org.netbeans.modules.spring.spi.beans.SpringConfigFileProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

public class SelectConfigFilesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final RequestProcessor rp = new RequestProcessor("Spring config file detection thread", 1, true);
    private final Set<File> alreadySelectedFiles;
    private final Project project;
    private List<File> availableFiles;
    private DialogDescriptor descriptor;
    private RequestProcessor.Task detectTask;
    private JButton checkAllButton;
    private JScrollPane configFileScrollPane;
    private JTable configFileTable;
    private JLabel detectedFilesLabel;
    private JLabel messageLabel;
    private JProgressBar progressBar;
    private JButton uncheckAllButton;

    public static SelectConfigFilesPanel create(Project project, Set<File> alreadySelectedFiles, ConfigFilesUIs.FileDisplayName fileDisplayName) {
        return new SelectConfigFilesPanel(project, alreadySelectedFiles, fileDisplayName);
    }

    public static SelectConfigFilesPanel create(List<File> availableFiles, Set<File> alreadySelectedFiles, ConfigFilesUIs.FileDisplayName fileDisplayName) {
        return new SelectConfigFilesPanel(availableFiles, alreadySelectedFiles, fileDisplayName);
    }

    private SelectConfigFilesPanel(List<File> availableFiles, Set<File> alreadySelectedFiles, ConfigFilesUIs.FileDisplayName fileDisplayName) {
        this.alreadySelectedFiles = alreadySelectedFiles;
        this.availableFiles = availableFiles;
        this.project = null;
        this.initComponents(fileDisplayName);
    }

    private SelectConfigFilesPanel(Project project, Set<File> alreadySelectedFiles, ConfigFilesUIs.FileDisplayName fileDisplayName) {
        this.project = project;
        this.alreadySelectedFiles = alreadySelectedFiles;
        this.initComponents(fileDisplayName);
    }

    private void initComponents(ConfigFilesUIs.FileDisplayName fileDisplayName) {
        this.initComponents();
        ConfigFilesUIs.setupFilesSelectionTable(this.configFileTable, fileDisplayName);
        this.configFileTable.getParent().setBackground(this.configFileTable.getBackground());
        this.configFileTable.getSelectionModel().setSelectionMode(0);
    }

    public boolean open() {
        String title = NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_ConfigFilesTitle");
        this.descriptor = new DialogDescriptor((Object)this, title, true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectConfigFilesPanel.this.cancelDetection();
            }
        });
        if (this.availableFiles == null) {
            this.descriptor.setValid(false);
            this.configFileTable.setEnabled(true);
            this.progressBar.setIndeterminate(true);
            this.detectTask = this.rp.create((Runnable)new FileDetector());
            this.detectTask.schedule(0);
        } else {
            this.updateAvailableFiles(this.availableFiles);
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        return this.descriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public List<File> getAvailableFiles() {
        return this.availableFiles;
    }

    public List<File> getSelectedFiles() {
        return ConfigFilesUIs.getSelectedFiles(this.configFileTable);
    }

    public List<File> getSelectableFiles() {
        return ConfigFilesUIs.getSelectableFiles(this.configFileTable);
    }

    private void cancelDetection() {
        if (this.detectTask != null) {
            this.detectTask.cancel();
        }
    }

    private void updateSelectAllNonButtons() {
        int maxSize = this.getSelectableFiles().size();
        int size = this.getSelectedFiles().size();
        this.checkAllButton.setEnabled(maxSize > 0 && size < maxSize);
        this.uncheckAllButton.setEnabled(maxSize > 0 && size > 0);
    }

    private void updateAvailableFiles(List<File> availableFiles) {
        this.availableFiles = availableFiles;
        this.configFileTable.setEnabled(true);
        ConfigFilesUIs.connectFilesSelectionTable(availableFiles, this.alreadySelectedFiles, this.configFileTable);
        ConfigFilesUIs.setCheckBoxListener(this.configFileTable, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectConfigFilesPanel.this.updateSelectAllNonButtons();
            }
        });
        this.configFileTable.getColumnModel().getColumn(0).setMaxWidth(0);
        String message = availableFiles.isEmpty() ? NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_NoFilesFound") : " ";
        this.messageLabel.setText(message);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBackground(this.getBackground());
        this.descriptor.setValid(true);
        this.updateSelectAllNonButtons();
    }

    private void initComponents() {
        this.detectedFilesLabel = new JLabel();
        this.configFileScrollPane = new JScrollPane();
        this.configFileTable = new JTable();
        this.progressBar = new JProgressBar();
        this.messageLabel = new JLabel();
        this.checkAllButton = new JButton();
        this.uncheckAllButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.detectedFilesLabel, (String)NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_ConfigFiles"));
        this.configFileTable.setIntercellSpacing(new Dimension(0, 0));
        this.configFileTable.setShowHorizontalLines(false);
        this.configFileTable.setShowVerticalLines(false);
        this.configFileTable.setTableHeader(null);
        this.configFileScrollPane.setViewportView(this.configFileTable);
        this.progressBar.setString(" ");
        this.progressBar.setStringPainted(true);
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_PleaseWait"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkAllButton, (String)NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_SelectConfigFilesPanel.btnCheckAll.text"));
        this.checkAllButton.setActionCommand(NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_SelectConfigFilesPanel.btnCheckAll.text"));
        this.checkAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectConfigFilesPanel.this.checkAllButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.uncheckAllButton, (String)NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_SelectConfigFilesPanel.btnUncheckAll.text"));
        this.uncheckAllButton.setActionCommand(NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_SelectConfigFilesPanel.btnUncheckAll.text"));
        this.uncheckAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectConfigFilesPanel.this.uncheckAllButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configFileScrollPane, -1, 704, Short.MAX_VALUE).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.detectedFilesLabel).addGroup(layout.createSequentialGroup().addComponent(this.checkAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uncheckAllButton)).addComponent(this.messageLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.detectedFilesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configFileScrollPane, -1, 189, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkAllButton).addComponent(this.uncheckAllButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2)));
        this.checkAllButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_SelectConfigFilesPanel.btnCheckAll.accessibleText"));
        this.uncheckAllButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SelectConfigFilesPanel.class, (String)"LBL_SelectConfigFilesPanel.btnUncheckAll.accessibleText"));
    }

    private void uncheckAllButtonActionPerformed(ActionEvent evt) {
        this.getTableModel().selectNone();
        this.configFileTable.repaint();
    }

    private void checkAllButtonActionPerformed(ActionEvent evt) {
        this.getTableModel().selectAll();
        this.configFileTable.repaint();
    }

    private ConfigFilesUIs.ConfigFileSelectionTableModel getTableModel() {
        return (ConfigFilesUIs.ConfigFileSelectionTableModel)this.configFileTable.getModel();
    }

    private final class FileDetector
    implements Runnable {
        private FileDetector() {
        }

        @Override
        public void run() {
            HashSet<File> result = new HashSet<File>();
            for (SourceGroup group : ProjectUtils.getSources((Project)SelectConfigFilesPanel.this.project).getSourceGroups("java")) {
                for (FileObject fo : NbCollections.iterable((Enumeration)group.getRootFolder().getChildren(true))) {
                    File file;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (!"text/x-springconfig+xml".equals(fo.getMIMEType()) || (file = FileUtil.toFile((FileObject)fo)) == null) continue;
                    result.add(file);
                }
            }
            for (SpringConfigFileProvider provider : SelectConfigFilesPanel.this.project.getLookup().lookupAll(SpringConfigFileProvider.class)) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                result.addAll(provider.getConfigFiles());
            }
            final ArrayList<File> sorted = new ArrayList<File>(result.size());
            sorted.addAll(result);
            Collections.sort(sorted);
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ FileDetector this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    this.this$1.SelectConfigFilesPanel.this.updateAvailableFiles(sorted);
                }
            });
        }
    }
}

