/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.javaee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.javaee.Bundle;
import org.netbeans.modules.gradle.javaee.api.GradleWebProject;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public class JavaEESourcesImpl
implements Sources {
    public static final String TYPE_DOC_ROOT = "doc_root";
    private final Project project;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final PropertyChangeListener pcl;
    private List<SourceGroup> webResourceRoots;

    public JavaEESourcesImpl(Project project) {
        this.project = project;
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("ProjectInfo".equals(event.getPropertyName()) && JavaEESourcesImpl.this.hasChanged()) {
                    JavaEESourcesImpl.this.cs.fireChange();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasChanged() {
        List<SourceGroup> resourceRoots = this.getWebSourceGroups();
        JavaEESourcesImpl javaEESourcesImpl = this;
        synchronized (javaEESourcesImpl) {
            if (this.webResourceRoots == null || !this.webResourceRoots.equals(resourceRoots)) {
                this.webResourceRoots = resourceRoots;
                return true;
            }
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.cs.hasListeners()) {
            NbGradleProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
        }
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
        if (!this.cs.hasListeners()) {
            NbGradleProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceGroup[] getSourceGroups(String str) {
        if (TYPE_DOC_ROOT.equals(str)) {
            JavaEESourcesImpl javaEESourcesImpl = this;
            synchronized (javaEESourcesImpl) {
                if (this.webResourceRoots == null) {
                    this.webResourceRoots = this.getWebSourceGroups();
                }
                return this.webResourceRoots.toArray(new SourceGroup[0]);
            }
        }
        return new SourceGroup[0];
    }

    private List<SourceGroup> getWebSourceGroups() {
        ArrayList<SourceGroup> sourceGroups = new ArrayList<SourceGroup>();
        ProjectWebRootProvider webRootProvider = (ProjectWebRootProvider)this.project.getLookup().lookup(ProjectWebRootProvider.class);
        GradleWebProject wp = GradleWebProject.get(this.project);
        if (webRootProvider != null && wp != null) {
            Collection webRoots = webRootProvider.getWebRoots();
            String projectDirPath = wp.getWebAppDir().getAbsolutePath();
            for (FileObject webRoot : webRoots) {
                boolean isDefault = webRoot.getPath().equals(projectDirPath);
                SourceGroup g = GenericSources.group((Project)this.project, (FileObject)webRoot, (String)TYPE_DOC_ROOT, (String)this.getDisplayName(webRoot, isDefault), null, null);
                if (isDefault) {
                    sourceGroups.add(0, g);
                    continue;
                }
                sourceGroups.add(g);
            }
        }
        return sourceGroups;
    }

    private String getDisplayName(FileObject webRoot, boolean isDefault) {
        return isDefault ? Bundle.LBL_DefaultWebPages() : Bundle.LBL_WebPages(webRoot.getPath());
    }
}

