/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.BaseUtilities;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class MultiModuleFileBuiltQueryImpl
implements FileBuiltQueryImplementation,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MultiModuleFileBuiltQueryImpl.class.getName());
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final MultiModule sourceModules;
    private final MultiModule testModules;
    private FileBuiltQueryImplementation delegate;
    private final Collection<Pair<ClassPath, PropertyChangeListener>> currentPaths;

    MultiModuleFileBuiltQueryImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull MultiModule sourceModules, @NonNull MultiModule testModules) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"sourceModules", (Object)sourceModules);
        Parameters.notNull((CharSequence)"testModules", (Object)testModules);
        this.helper = helper;
        this.eval = evaluator;
        this.sourceModules = sourceModules;
        this.testModules = testModules;
        this.currentPaths = new ArrayList<Pair<ClassPath, PropertyChangeListener>>();
        this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
        this.sourceModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.sourceModules));
        this.testModules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.testModules));
    }

    public FileBuiltQuery.Status getStatus(FileObject file) {
        return (FileBuiltQuery.Status)ProjectManager.mutex().readAccess(() -> this.getDelegate().getStatus(file));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName == null) {
            this.invalidate();
        } else {
            switch (propName) {
                case "build.modules.dir": 
                case "build.test.modules.dir": {
                    if (evt.getSource() != this.eval) break;
                    this.invalidate();
                    break;
                }
                case "modules": {
                    if (evt.getSource() != this.sourceModules && evt.getSource() != this.testModules) break;
                    this.invalidate();
                    break;
                }
                case "entries": {
                    Object src = evt.getSource();
                    if (!(src instanceof ClassPath) || !this.isCurrentPath((ClassPath)src)) break;
                    this.invalidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private FileBuiltQueryImplementation getDelegate() {
        FileBuiltQueryImplementation res;
        MultiModuleFileBuiltQueryImpl multiModuleFileBuiltQueryImpl = this;
        synchronized (multiModuleFileBuiltQueryImpl) {
            res = this.delegate;
        }
        if (res == null) {
            ArrayList from = new ArrayList();
            ArrayList to = new ArrayList();
            Set<ClassPath> classpaths = Collections.newSetFromMap(new IdentityHashMap());
            MultiModuleFileBuiltQueryImpl.collectRoots(this.sourceModules, "build.modules.dir", from, to, classpaths);
            MultiModuleFileBuiltQueryImpl.collectRoots(this.testModules, "build.test.modules.dir", from, to, classpaths);
            res = this.helper.createGlobFileBuiltQuery(this.eval, from.toArray(new String[0]), to.toArray(new String[0]));
            MultiModuleFileBuiltQueryImpl multiModuleFileBuiltQueryImpl2 = this;
            synchronized (multiModuleFileBuiltQueryImpl2) {
                if (this.delegate == null) {
                    for (Pair<ClassPath, PropertyChangeListener> cplp : this.currentPaths) {
                        ((ClassPath)cplp.first()).removePropertyChangeListener((PropertyChangeListener)cplp.second());
                    }
                    this.currentPaths.clear();
                    for (ClassPath scp : classpaths) {
                        PropertyChangeListener l = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)scp);
                        scp.addPropertyChangeListener(l);
                        this.currentPaths.add((Pair<ClassPath, PropertyChangeListener>)Pair.of((Object)scp, (Object)l));
                    }
                    this.delegate = res;
                } else {
                    res = this.delegate;
                }
            }
        }
        return res;
    }

    private synchronized boolean isCurrentPath(@NonNull ClassPath cp) {
        for (Pair<ClassPath, PropertyChangeListener> p : this.currentPaths) {
            if (p.first() != cp) continue;
            return true;
        }
        return false;
    }

    private synchronized void invalidate() {
        this.delegate = null;
    }

    private static void collectRoots(@NonNull MultiModule modules, @NonNull String buildDirProp, @NonNull List<? super String> from, @NonNull List<? super String> to, @NonNull Set<? super ClassPath> cps) {
        for (String string : modules.getModuleNames()) {
            String dest = String.format("${%s}/%s/*.class", buildDirProp, string);
            ClassPath scp = modules.getModuleSources(string);
            if (scp == null) continue;
            for (ClassPath.Entry e : scp.entries()) {
                try {
                    File f = BaseUtilities.toFile((URI)e.getURL().toURI());
                    String source = String.format("%s/*.java", f.getAbsolutePath());
                    from.add(source);
                    to.add(dest);
                }
                catch (IllegalArgumentException | URISyntaxException exc) {
                    LOG.log(Level.WARNING, "Cannot convert source root: {0} to file.", e.getURL());
                }
            }
            cps.add((ClassPath)scp);
        }
    }
}

