/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.ObjectLifecyclePolicy;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PutObjectLifecyclePolicyResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcClientRequestId;
    private String eTag;
    private ObjectLifecyclePolicy objectLifecyclePolicy;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public ObjectLifecyclePolicy getObjectLifecyclePolicy() {
        return this.objectLifecyclePolicy;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcClientRequestId", "eTag", "objectLifecyclePolicy"})
    private PutObjectLifecyclePolicyResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcClientRequestId, String eTag, ObjectLifecyclePolicy objectLifecyclePolicy) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcClientRequestId = opcClientRequestId;
        this.eTag = eTag;
        this.objectLifecyclePolicy = objectLifecyclePolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",eTag=").append(String.valueOf(this.eTag));
        sb.append(",objectLifecyclePolicy=").append(String.valueOf((Object)this.objectLifecyclePolicy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutObjectLifecyclePolicyResponse)) {
            return false;
        }
        PutObjectLifecyclePolicyResponse other = (PutObjectLifecyclePolicyResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.eTag, other.eTag) && Objects.equals((Object)this.objectLifecyclePolicy, (Object)other.objectLifecyclePolicy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.eTag == null ? 43 : this.eTag.hashCode());
        result = result * 59 + (this.objectLifecyclePolicy == null ? 43 : this.objectLifecyclePolicy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<PutObjectLifecyclePolicyResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcClientRequestId;
        private String eTag;
        private ObjectLifecyclePolicy objectLifecyclePolicy;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder objectLifecyclePolicy(ObjectLifecyclePolicy objectLifecyclePolicy) {
            this.objectLifecyclePolicy = objectLifecyclePolicy;
            return this;
        }

        public Builder copy(PutObjectLifecyclePolicyResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.eTag(o.getETag());
            this.objectLifecyclePolicy(o.getObjectLifecyclePolicy());
            return this;
        }

        public PutObjectLifecyclePolicyResponse build() {
            return new PutObjectLifecyclePolicyResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcClientRequestId, this.eTag, this.objectLifecyclePolicy);
        }
    }
}

