/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.center;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.notifications.NotificationImpl;

public class NotificationTableModel
extends AbstractTableModel {
    static final int PRIORITY_COLUMN = 0;
    static final int MESSAGE_COLUMN = 1;
    static final int TIMESTAMP_COLUMN = 2;
    static final int CATEGORY_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private final List<NotificationImpl> entries = new ArrayList<NotificationImpl>();

    public void setEntries(List<NotificationImpl> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
        this.fireTableDataChanged();
    }

    public NotificationImpl getEntry(int index) {
        return this.entries.get(index);
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        NotificationImpl notification = this.getEntry(rowIndex);
        if (notification == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return notification.getPriority();
            }
            case 2: {
                return notification.getDateCreated();
            }
            case 3: {
                return notification.getCategory().getDisplayName();
            }
            case 1: {
                return notification.getTitle();
            }
        }
        throw new IllegalStateException("Invalid columnIndex=" + columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    void updateIndex(int index) {
        this.fireTableRowsUpdated(index, index);
    }
}

