/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class IncorrectConstructorPropertyPromotionHintError
extends HintErrorRule {
    private FileObject fileObject;

    public String getDisplayName() {
        return Bundle.IncorrectConstructorPropertyPromotionHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            for (FormalParameter parameter : checkVisitor.getIncorrectAbstractConstructorParameters()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(parameter, Bundle.IncorrectConstructorPropertyPromotionHintError_abstract_desc(), hints);
            }
            for (FormalParameter parameter : checkVisitor.getIncorrectFunctionParameters()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(parameter, Bundle.IncorrectConstructorPropertyPromotionHintError_non_constructor_desc(), hints);
            }
            for (FormalParameter parameter : checkVisitor.getIncorrectVariadicParameters()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(parameter, Bundle.IncorrectConstructorPropertyPromotionHintError_with_variadic_desc(), hints);
            }
        }
    }

    private void addHint(ASTNode node, String description, List<Hint> hints) {
        this.addHint(node, description, hints, Collections.emptyList());
    }

    private void addHint(ASTNode node, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, new OffsetRange(node.getStartOffset(), node.getEndOffset()), fixes, 500));
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final Set<FormalParameter> incorrectAbstractConstructorParameters = new HashSet<FormalParameter>();
        private final Set<FormalParameter> incorrectFunctionParameters = new HashSet<FormalParameter>();
        private final Set<FormalParameter> incorrectVariadicParameters = new HashSet<FormalParameter>();

        private CheckVisitor() {
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            FunctionDeclaration function = node.getFunction();
            List<FormalParameter> parameters = function.getFormalParameters();
            if (CodeUtils.isConstructor(node)) {
                for (FormalParameter parameter : parameters) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (!BodyDeclaration.Modifier.isVisibilityModifier(parameter.getModifier()) && !BodyDeclaration.Modifier.isSetVisibilityModifier(parameter.getModifier())) continue;
                    Block body = function.getBody();
                    if (body == null || !body.isCurly() && body.getStatements().isEmpty()) {
                        this.incorrectAbstractConstructorParameters.add(parameter);
                    }
                    if (!parameter.isVariadic()) continue;
                    this.incorrectVariadicParameters.add(parameter);
                }
                this.scan(node.getAttributes());
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkParameters(node.getFormalParameters());
            super.visit(node);
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkParameters(node.getFormalParameters());
            super.visit(node);
        }

        @Override
        public void visit(ArrowFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkParameters(node.getFormalParameters());
            super.visit(node);
        }

        private void checkParameters(List<FormalParameter> parameters) {
            for (FormalParameter parameter : parameters) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (!BodyDeclaration.Modifier.isVisibilityModifier(parameter.getModifier()) && !BodyDeclaration.Modifier.isSetVisibilityModifier(parameter.getModifier())) continue;
                this.incorrectFunctionParameters.add(parameter);
            }
        }

        public Set<FormalParameter> getIncorrectAbstractConstructorParameters() {
            return Collections.unmodifiableSet(this.incorrectAbstractConstructorParameters);
        }

        public Set<FormalParameter> getIncorrectFunctionParameters() {
            return Collections.unmodifiableSet(this.incorrectFunctionParameters);
        }

        public Set<FormalParameter> getIncorrectVariadicParameters() {
            return Collections.unmodifiableSet(this.incorrectVariadicParameters);
        }
    }
}

