/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.UnpackableArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public final class PHP74UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP74UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP74UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_74);
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(ArrowFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkArrowFunction(node);
            super.visit(node);
        }

        @Override
        public void visit(Assignment node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkNullCoalescingAssignment(node);
            super.visit(node);
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkTypedProperties(node);
            super.visit(node);
        }

        @Override
        public void visit(UnpackableArrayElement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkUnpackableArrayElement(node);
            super.visit(node);
        }

        @Override
        public void visit(Scalar scalar) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkNumericLiteralSeparator(scalar);
            super.visit(scalar);
        }

        private void checkNullCoalescingAssignment(Assignment node) {
            if (node.getOperator() == Assignment.Type.COALESCE_EQUAL) {
                this.createError(node);
            }
        }

        private void checkTypedProperties(FieldsDeclaration node) {
            if (node.getFieldType() != null) {
                this.createError(node);
            }
        }

        private void checkUnpackableArrayElement(UnpackableArrayElement node) {
            this.createError(node);
        }

        private void checkNumericLiteralSeparator(Scalar node) {
            if ((node.getScalarType() == Scalar.Type.INT || node.getScalarType() == Scalar.Type.FLOAT || node.getScalarType() == Scalar.Type.REAL) && node.getStringValue().contains("_")) {
                this.createError(node);
            }
        }

        private void checkArrowFunction(ArrowFunctionDeclaration node) {
            this.createError(node);
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP74VersionError(this.fileObject, startOffset, endOffset));
        }
    }

    private static final class PHP74VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.74";

        private PHP74VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP74VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP74VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }
}

