/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Map;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.IncompatibleMask;
import org.netbeans.modules.java.hints.LoggerNotStaticFinal;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.NbBundle;

public class PointlessBitwiseExpression {
    public static ErrorDescription checkPointlessShiftExpression(HintContext ctx) {
        TreePath treePath = ctx.getPath();
        Map variables = ctx.getVariables();
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath tree = (TreePath)variables.get("$c");
        Long value = IncompatibleMask.getConstant(tree, ctx);
        if (value == null) {
            return null;
        }
        if (value == 0L) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)treePath, (String)NbBundle.getMessage(PointlessBitwiseExpression.class, (String)"MSG_PointlessBitwiseExpression"), (Fix[])new Fix[]{new FixImpl(compilationInfo, treePath, NbBundle.getMessage(LoggerNotStaticFinal.class, (String)"MSG_PointlessBitwiseExpression_fix"), true).toEditorFix()});
        }
        return null;
    }

    public static ErrorDescription checkPointlessBitwiseExpression(HintContext ctx) {
        boolean left;
        TreePath treePath = ctx.getPath();
        CompilationInfo compilationInfo = ctx.getInfo();
        Map variables = ctx.getVariables();
        TreePath tree = (TreePath)variables.get("$c");
        Long value = IncompatibleMask.getConstant(tree, ctx);
        boolean bl = left = treePath.getLeaf().getKind() != Tree.Kind.AND;
        if (value != null && value == 0L) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)treePath, (String)NbBundle.getMessage(PointlessBitwiseExpression.class, (String)"MSG_PointlessBitwiseExpression"), (Fix[])new Fix[]{new FixImpl(compilationInfo, treePath, NbBundle.getMessage(LoggerNotStaticFinal.class, (String)(left ? "MSG_PointlessBitwiseExpression_fix" : "MSG_PointlessBitwiseExpression_fix2")), left).toEditorFix()});
        }
        tree = (TreePath)variables.get("$v");
        value = IncompatibleMask.getConstant(tree, ctx);
        if (value != null && value == 0L) {
            return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)treePath, (String)NbBundle.getMessage(PointlessBitwiseExpression.class, (String)"MSG_PointlessBitwiseExpression"), (Fix[])new Fix[]{new FixImpl(compilationInfo, treePath, NbBundle.getMessage(LoggerNotStaticFinal.class, (String)(left ? "MSG_PointlessBitwiseExpression_fix" : "MSG_PointlessBitwiseExpression_fix2")), !left).toEditorFix()});
        }
        return null;
    }

    private static final class FixImpl
    extends JavaFix {
        private final String text;
        private boolean left;

        public FixImpl(CompilationInfo info, TreePath tp, String text, boolean left) {
            super(info, tp);
            this.text = text;
            this.left = left;
        }

        public String getText() {
            return this.text;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath tp = ctx.getPath();
            Tree vt = tp.getLeaf();
            BinaryTree e = (BinaryTree)vt;
            wc.rewrite(vt, (Tree)(this.left ? e.getLeftOperand() : e.getRightOperand()));
        }
    }
}

