/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNodeGen;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;

@GenerateUncached
public abstract class JSTrimWhitespaceNode
extends JavaScriptBaseNode {
    @NeverDefault
    public static JSTrimWhitespaceNode create() {
        return JSTrimWhitespaceNodeGen.create();
    }

    public abstract TruffleString executeString(TruffleString var1);

    protected boolean startsOrEndsWithWhitespace(TruffleString.ReadCharUTF16Node readRawNode, TruffleString string, InlinedConditionProfile isFastNonWhitespace, InlinedConditionProfile isFastWhitespace) {
        int len = Strings.length(string);
        assert (len > 0);
        return JSTrimWhitespaceNode.isWhiteSpace(readRawNode, string, 0, this, isFastNonWhitespace, isFastWhitespace) || JSTrimWhitespaceNode.isWhiteSpace(readRawNode, string, len - 1, this, isFastNonWhitespace, isFastWhitespace);
    }

    @Specialization(guards={"stringLength(string) == 0"})
    protected static TruffleString doStringZero(TruffleString string) {
        return string;
    }

    @Specialization(guards={"stringLength(string) > 0", "!startsOrEndsWithWhitespace(readRawNode, string, isFastNonWhitespace, isFastWhitespace)"}, limit="1")
    protected static TruffleString doStringNoWhitespace(TruffleString string, @Cached @Cached.Shared(value="readChar") TruffleString.ReadCharUTF16Node readRawNode, @Cached @Cached.Shared(value="isFastNonWhitespace") InlinedConditionProfile isFastNonWhitespace, @Cached @Cached.Shared(value="isFastWhitespace") InlinedConditionProfile isFastWhitespace) {
        return string;
    }

    @Specialization(guards={"stringLength(string) > 0", "startsOrEndsWithWhitespace(readRawNode, string, isFastNonWhitespace, isFastWhitespace)"}, limit="1")
    protected final TruffleString doString(TruffleString string, @Cached @Cached.Shared(value="readChar") TruffleString.ReadCharUTF16Node readRawNode, @Cached @Cached.Shared(value="isFastNonWhitespace") InlinedConditionProfile isFastNonWhitespace, @Cached @Cached.Shared(value="isFastWhitespace") InlinedConditionProfile isFastWhitespace, @Cached TruffleString.SubstringByteIndexNode substringNode, @Cached InlinedBranchProfile startsWithWhitespaceBranch, @Cached InlinedBranchProfile endsWithWhitespaceBranch, @Cached @Cached.Exclusive InlinedConditionProfile isEmpty) {
        int len = Strings.length(string);
        int firstIdx = 0;
        if (JSTrimWhitespaceNode.isWhiteSpace(readRawNode, string, 0, this, isFastNonWhitespace, isFastWhitespace)) {
            startsWithWhitespaceBranch.enter((Node)this);
            firstIdx = JSRuntime.firstNonWhitespaceIndex(string, readRawNode);
        }
        int lastIdx = len - 1;
        if (JSTrimWhitespaceNode.isWhiteSpace(readRawNode, string, len - 1, this, isFastNonWhitespace, isFastWhitespace)) {
            endsWithWhitespaceBranch.enter((Node)this);
            lastIdx = JSRuntime.lastNonWhitespaceIndex(string, readRawNode);
        }
        if (isEmpty.profile((Node)this, firstIdx > lastIdx)) {
            return Strings.EMPTY_STRING;
        }
        return Strings.substring(JavaScriptLanguage.get(this).getJSContext(), substringNode, string, firstIdx, lastIdx + 1 - firstIdx);
    }

    private static boolean isWhiteSpace(TruffleString.ReadCharUTF16Node readRawNode, TruffleString str, int index, Node node, InlinedConditionProfile isFastNonWhitespace, InlinedConditionProfile isFastWhitespace) {
        char c = Strings.charAt(readRawNode, str, index);
        if (isFastNonWhitespace.profile(node, ' ' < c && c < '\u00a0')) {
            return false;
        }
        if (isFastWhitespace.profile(node, c == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            return true;
        }
        return JSRuntime.isWhiteSpaceOrLineTerminator(c);
    }
}

