/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalCalendarNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getCalendarPropertyNode;

    protected ToTemporalCalendarNode() {
    }

    public abstract JSDynamicObject execute(Object var1);

    @Specialization
    public JSDynamicObject toTemporalCalendar(Object itemParam, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isCalendarProfile, @Cached InlinedConditionProfile hasCalendarProfile, @Cached InlinedConditionProfile hasCalendar2Profile, @Cached InlinedBranchProfile parseBranch) {
        TruffleString identifier;
        Object item = itemParam;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = TemporalUtil.toJSDynamicObject(item, this, errorBranch);
            if (isCalendarProfile.profile((Node)this, item instanceof JSTemporalCalendarHolder)) {
                return ((JSTemporalCalendarHolder)((Object)item)).getCalendar();
            }
            if (hasCalendarProfile.profile((Node)this, !JSObject.hasProperty(itemObj, TemporalConstants.CALENDAR))) {
                return itemObj;
            }
            item = this.getCalendarProperty(itemObj);
            if (hasCalendar2Profile.profile((Node)this, isObjectNode.executeBoolean(item) && !JSObject.hasProperty((JSDynamicObject)((Object)item), TemporalConstants.CALENDAR))) {
                return (JSDynamicObject)((Object)item);
            }
        }
        if (!TemporalUtil.isBuiltinCalendar(identifier = toStringNode.executeString(item))) {
            parseBranch.enter((Node)this);
            identifier = TemporalUtil.parseTemporalCalendarString(identifier);
            if (!TemporalUtil.isBuiltinCalendar(identifier)) {
                throw TemporalErrors.createRangeErrorCalendarUnknown();
            }
        }
        return JSTemporalCalendar.create(this.getLanguage().getJSContext(), this.getRealm(), identifier);
    }

    private Object getCalendarProperty(JSDynamicObject obj) {
        if (this.getCalendarPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getCalendarPropertyNode = (PropertyGetNode)this.insert(PropertyGetNode.create(TemporalConstants.CALENDAR, this.getLanguage().getJSContext()));
        }
        return this.getCalendarPropertyNode.getValue((Object)obj);
    }
}

