/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.attach;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.modules.java.lsp.server.debugging.attach.Bundle;
import org.netbeans.modules.java.lsp.server.debugging.attach.Processes;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.openide.util.RequestProcessor;

public final class AttachNativeConfigurations {
    static final String CONFIG_TYPE = "nativeimage";
    static final String CONFIG_REQUEST = "attach";
    static final RequestProcessor RP = new RequestProcessor(AttachNativeConfigurations.class);

    public static CompletableFuture<Object> findProcessAttachTo(NbCodeLanguageClient client) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> AttachNativeConfigurations.listProcessesToAttachTo(client), (Executor)RP).thenCompose(params -> client.showQuickPick((ShowQuickPickParams)params))).thenApply(itemsList -> {
            if (itemsList == null || itemsList.isEmpty()) {
                return null;
            }
            return ((QuickPickItem)itemsList.get(0)).getUserData();
        });
    }

    private static ShowQuickPickParams listProcessesToAttachTo(NbCodeLanguageClient client) {
        ArrayList<QuickPickItem> items = new ArrayList<QuickPickItem>();
        List<Processes.ProcessInfo> processes = Processes.getAllProcesses();
        for (Processes.ProcessInfo info : processes) {
            items.add(AttachNativeConfigurations.createQuickPickItem(info));
        }
        if (items.isEmpty()) {
            throw ErrorUtilities.createResponseErrorException("No debuggable native process found.", ResponseErrorCode.RequestCancelled);
        }
        return new ShowQuickPickParams(Bundle.LBL_PickNativeProcessAttach(), items);
    }

    private static QuickPickItem createQuickPickItem(Processes.ProcessInfo info) {
        String label = Long.toString(info.getPid());
        String description = info.getCommand();
        String userData = info.getPid() + " " + info.getExecutable();
        return new QuickPickItem(label, description, null, false, userData);
    }
}

