/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.AtomicLockListener;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.modules.java.lsp.server.Utils;

final class FormatterDocument
implements StyledDocument,
LineDocument,
AtomicLockDocument {
    private final StyledDocument doc;
    private final List<TextEdit> edits = new ArrayList<TextEdit>();
    private TextEdit last = null;

    FormatterDocument(StyledDocument lineDocument) {
        this.doc = lineDocument;
    }

    List<TextEdit> getEdits() {
        return this.edits;
    }

    @Override
    public Style addStyle(String nm, Style parent) {
        return this.doc.addStyle(nm, parent);
    }

    @Override
    public void removeStyle(String nm) {
        this.doc.removeStyle(nm);
    }

    @Override
    public Style getStyle(String nm) {
        return this.doc.getStyle(nm);
    }

    @Override
    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.doc.setCharacterAttributes(offset, length, s, replace);
    }

    @Override
    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.doc.setParagraphAttributes(offset, length, s, replace);
    }

    @Override
    public void setLogicalStyle(int pos, Style s) {
        this.doc.setLogicalStyle(pos, s);
    }

    @Override
    public Style getLogicalStyle(int p) {
        return this.doc.getLogicalStyle(p);
    }

    @Override
    public Element getParagraphElement(int pos) {
        return this.doc.getParagraphElement(pos);
    }

    @Override
    public Element getCharacterElement(int pos) {
        return this.doc.getCharacterElement(pos);
    }

    @Override
    public Color getForeground(AttributeSet attr) {
        return this.doc.getForeground(attr);
    }

    @Override
    public Color getBackground(AttributeSet attr) {
        return this.doc.getBackground(attr);
    }

    @Override
    public Font getFont(AttributeSet attr) {
        return this.doc.getFont(attr);
    }

    @Override
    public int getLength() {
        return this.doc.getLength();
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.doc.addDocumentListener(listener);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.doc.removeDocumentListener(listener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.doc.addUndoableEditListener(listener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.doc.removeUndoableEditListener(listener);
    }

    @Override
    public Object getProperty(Object key) {
        return this.doc.getProperty(key);
    }

    @Override
    public void putProperty(Object key, Object value) {
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        org.eclipse.lsp4j.Position pos = Utils.createPosition(this.doc, offs);
        if (this.last != null && pos.equals((Object)this.last.getRange().getStart()) && pos.equals((Object)this.last.getRange().getEnd())) {
            this.last.getRange().setEnd(Utils.createPosition(this.doc, offs + len));
        } else {
            this.last = new TextEdit(new Range(pos, Utils.createPosition(this.doc, offs + len)), "");
            this.edits.add(this.last);
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        org.eclipse.lsp4j.Position pos = Utils.createPosition(this.doc, offset);
        if (this.last != null && pos.equals((Object)this.last.getRange().getStart())) {
            if (str != null) {
                this.last.setNewText(this.last.getNewText() + str);
            }
        } else {
            this.last = new TextEdit(new Range(pos, pos), str != null ? str : "");
            this.edits.add(this.last);
        }
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        return this.doc.getText(offset, length);
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.doc.getText(offset, length, txt);
    }

    @Override
    public Position getStartPosition() {
        return this.doc.getStartPosition();
    }

    @Override
    public Position getEndPosition() {
        return this.doc.getEndPosition();
    }

    @Override
    public Position createPosition(int offs) throws BadLocationException {
        return this.doc.createPosition(offs);
    }

    @Override
    public Element[] getRootElements() {
        return this.doc.getRootElements();
    }

    @Override
    public Element getDefaultRootElement() {
        return this.doc.getDefaultRootElement();
    }

    @Override
    public void render(Runnable r) {
        this.doc.render(r);
    }

    public Position createPosition(int offset, Position.Bias bias) throws BadLocationException {
        LineDocument ldoc = (LineDocument)LineDocumentUtils.as((Document)this.doc, LineDocument.class);
        return ldoc.createPosition(offset, bias);
    }

    public Document getDocument() {
        return this;
    }

    public void atomicUndo() {
        AtomicLockDocument bdoc = (AtomicLockDocument)LineDocumentUtils.as((Document)this.doc, AtomicLockDocument.class);
        bdoc.atomicUndo();
    }

    public void runAtomic(Runnable r) {
        AtomicLockDocument bdoc = (AtomicLockDocument)LineDocumentUtils.as((Document)this.doc, AtomicLockDocument.class);
        bdoc.runAtomic(r);
    }

    public void runAtomicAsUser(Runnable r) {
        AtomicLockDocument bdoc = (AtomicLockDocument)LineDocumentUtils.as((Document)this.doc, AtomicLockDocument.class);
        bdoc.runAtomicAsUser(r);
    }

    public void addAtomicLockListener(AtomicLockListener l) {
        AtomicLockDocument bdoc = (AtomicLockDocument)LineDocumentUtils.as((Document)this.doc, AtomicLockDocument.class);
        bdoc.addAtomicLockListener(l);
    }

    public void removeAtomicLockListener(AtomicLockListener l) {
        AtomicLockDocument bdoc = (AtomicLockDocument)LineDocumentUtils.as((Document)this.doc, AtomicLockDocument.class);
        bdoc.removeAtomicLockListener(l);
    }
}

